<?php

namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\KelasModel;
use App\Models\SiswaModel;
use App\Models\TahunAjaranModel;
use App\Models\CatatanWaliKelasModel;

class CatatanWaliKelas extends BaseController
{
    protected $kelasModel;
    protected $siswaModel;
    protected $tahunAjaranModel;
    protected $catatanWaliKelasModel;

    public function __construct()
    {
        $this->kelasModel = new KelasModel();
        $this->siswaModel = new SiswaModel();
        $this->tahunAjaranModel = new TahunAjaranModel();
        $this->catatanWaliKelasModel = new CatatanWaliKelasModel();
    }

    public function index()
    {
        $guru_id = session()->get('user_id');

        // Menggunakan guru_kelas_id
        $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();

        if (empty($wali_kelas_data)) {
            session()->setFlashdata('error', 'Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya untuk wali kelas.');
            return redirect()->to(base_url('guru/dashboard'));
        }

        $selected_kelas_id = $wali_kelas_data['id_kelas'];
        $selected_semester = $this->request->getPost('semester') ?? old('semester') ?? '';
        $selected_tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id') ?? old('tahun_ajaran_id') ?? '';

        $siswa_list = [];
        $catatan_data = [];

        if (!empty($selected_semester) && !empty($selected_tahun_ajaran_id)) {
            $siswa_list = $this->siswaModel->where('kelas_id', $selected_kelas_id)->findAll();
            
            $catatan = $this->catatanWaliKelasModel->where([
                'tahun_ajaran_id' => $selected_tahun_ajaran_id,
                'semester' => $selected_semester
            ])->findAll();

            foreach ($catatan as $c) {
                $catatan_data[$c['siswa_id']] = $c;
            }
        }

        $data = [
            'title' => 'Catatan Wali Kelas',
            'kelas' => $wali_kelas_data,
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(),
            'siswa_list' => $siswa_list,
            'catatan_data' => $catatan_data,
            'selected_semester' => $selected_semester,
            'selected_tahun_ajaran_id' => $selected_tahun_ajaran_id,
        ];
        
        return view('guru/catatan_wali_kelas/index', $data);
    }

    public function save()
    {
        $guru_id = session()->get('user_id');
        // Menggunakan guru_kelas_id
        $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();

        if (empty($wali_kelas_data)) {
            session()->setFlashdata('error', 'Anda tidak ditugaskan sebagai wali kelas.');
            return redirect()->to(base_url('guru/catatan_wali_kelas'));
        }

        $siswa_id_array = $this->request->getPost('siswa_id');
        $catatan_umum = $this->request->getPost('catatan_umum');
        $saran_saran = $this->request->getPost('saran_saran');
        $semester = $this->request->getPost('semester');
        $tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id');

        if (empty($siswa_id_array) || empty($semester) || empty($tahun_ajaran_id)) {
            session()->setFlashdata('error', 'Data tidak lengkap. Pastikan Anda sudah memilih semester dan tahun ajaran.');
            return redirect()->to(base_url('guru/catatan_wali_kelas'));
        }

        $db = \Config\Database::connect();
        $db->transBegin();

        $success_count = 0;
        foreach ($siswa_id_array as $siswa_id) {
            $data_to_save = [
                'siswa_id' => $siswa_id,
                'semester' => $semester,
                'tahun_ajaran_id' => $tahun_ajaran_id,
                'catatan_umum' => $catatan_umum[$siswa_id],
                'saran_saran' => $saran_saran[$siswa_id],
            ];
            
            $existing_record = $this->catatanWaliKelasModel->where([
                'siswa_id' => $siswa_id,
                'semester' => $semester,
                'tahun_ajaran_id' => $tahun_ajaran_id,
            ])->first();

            if ($existing_record) {
                $this->catatanWaliKelasModel->update($existing_record['id'], $data_to_save);
            } else {
                $this->catatanWaliKelasModel->insert($data_to_save);
            }
            $success_count++;
        }

        if ($db->transStatus() === false) {
            $db->transRollback();
            session()->setFlashdata('error', 'Gagal menyimpan catatan wali kelas.');
        } else {
            $db->transCommit();
            session()->setFlashdata('success', 'Catatan wali kelas berhasil disimpan.');
        }

        return redirect()->to(base_url('guru/catatan_wali_kelas'));
    }
}