<?php

namespace App\Models;

use CodeIgniter\Model;

class KenaikanKelasModel extends Model
{
    protected $table            = 'kenaikan_kelas';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    
    // KOREKSI: Tambahkan semua kolom yang digunakan oleh Controller
    protected $allowedFields    = [
        'siswa_id', 
        'kelas_lama_id',         // Tambahan: Kelas asal
        'kelas_baru_id',         // Tambahan: Kelas tujuan (menggantikan kelas_berikutnya_id)
        'tahun_ajaran_id', 
        'status_kenaikan', 
        'is_processed',          // Tambahan: Status pindah sistem (0/1)
        'catatan',               
        'created_at',            // Tambahan (diisi manual)
        'updated_at'             // Tambahan (diisi manual)
    ];

    // KOREKSI KRITIS: Menonaktifkan useTimestamps karena kita mengisinya manual 
    protected $useTimestamps = false; 
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'siswa_id'          => 'required|is_natural_no_zero',
        'tahun_ajaran_id'   => 'required|is_natural_no_zero',
        // KOREKSI: Sinkronisasi dengan nilai di Controller: 'Naik', 'Tinggal', 'Lulus'
        'status_kenaikan'   => 'required|in_list[Naik,Tinggal,Lulus]', 
        'kelas_baru_id' => 'permit_empty|is_natural_no_zero', 
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
}