<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>Data Fisik Anak<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h1 class="card-title">Data Fisik Anak</h1>
        </div>
        <div class="card-body">
            <?php if (isset($message) && $message == 'Anda tidak terdaftar sebagai guru kelas. Halaman ini hanya bisa diakses oleh wali kelas.') : ?>
                <div class="alert alert-danger">
                    <?= esc($message) ?>
                </div>
            <?php else: ?>
                <a href="<?= base_url('guru/fisik_anak/create') ?>" class="btn btn-primary mb-3">Tambah Data Fisik</a>
                
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success">
                        <?= session()->getFlashdata('success') ?>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger">
                        <?= session()->getFlashdata('error') ?>
                    </div>
                <?php endif; ?>

                <?php if (isset($tahun_ajaran_aktif)) : ?>
                    <p>Data ditampilkan untuk: <strong>Tahun Ajaran <?= esc($tahun_ajaran_aktif['nama_tahun']) ?></strong>, <strong>Semester <?= ($tahun_ajaran_aktif['semester'] == 1) ? 'Ganjil' : 'Genap' ?></strong></p>
                <?php endif; ?>

                <?php if (empty($fisik_anak)) : ?>
                    <div class="alert alert-info">Belum ada data fisik anak untuk semester ini.</div>
                <?php else : ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Siswa</th>
                                    <th>Kelas</th>
                                    <th>Berat Badan (kg)</th>
                                    <th>Tinggi Badan (cm)</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; ?>
                                <?php foreach ($fisik_anak as $data) : ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($data['nama_lengkap']) ?></td>
                                        <td><?= esc($data['nama_kelas']) ?></td>
                                        <td><?= esc($data['berat_badan']) ?></td>
                                        <td><?= esc($data['tinggi_badan']) ?></td>
                                        <td>
                                            <a href="<?= base_url('guru/fisik_anak/edit/' . $data['id']) ?>" class="btn btn-sm btn-primary">Edit</a>
                                            <a href="<?= base_url('guru/fisik_anak/delete/' . $data['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?');">Hapus</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?= $this->endSection() ?>