<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>
<?= $title ?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <h2><i class="fa fa-edit"></i> <?= $title ?></h2>
    
    <div class="alert alert-warning">
        <p><strong>Perhatian!</strong> Halaman ini digunakan untuk mengoreksi status siswa yang **Tinggal Kelas**. Pastikan semua koreksi sudah dilakukan sebelum menekan tombol "Simpan Koreksi".</p>
        <p class="mb-0">Kelas Lama: <strong><?= esc($siswa_data[0]['nama_kelas_lama'] ?? 'N/A') ?></strong> | Tahun Ajaran ID: <strong><?= esc($ta_id) ?></strong></p>
    </div>

    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Siswa Kelas <?= esc($siswa_data[0]['nama_kelas_lama'] ?? 'N/A') ?></h6>
        </div>
        <div class="card-body">
            
            <form action="<?= base_url('guru/siswa/saveKoreksiStatusBatch') ?>" method="post">
                <?= csrf_field() ?>
                <input type="hidden" name="kelas_lama_id" value="<?= esc($kelas_lama_id) ?>">
                <input type="hidden" name="ta_id" value="<?= esc($ta_id) ?>">
                
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama Siswa</th>
                                <th>Status Rapor Saat Ini</th>
                                <th>Kelas Tujuan Sistem</th>
                                <th>Koreksi Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; ?>
                            <?php foreach ($siswa_data as $siswa): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= esc($siswa['nama_lengkap']) ?></td>
                                <td>
                                    <span class="badge bg-<?= $siswa['status_kenaikan'] == 'Naik' ? 'success' : ($siswa['status_kenaikan'] == 'Lulus' ? 'info' : 'danger') ?>">
                                        <?= esc($siswa['status_kenaikan']) ?>
                                    </span>
                                </td>
                                <td>
                                    <?= esc($siswa['status_kenaikan'] == 'Lulus' ? 'LULUS' : ($siswa['nama_kelas_baru'] ?? esc($siswa['nama_kelas_lama'] . ' (Tinggal)'))) ?>
                                </td>
                                <td>
                                    <select class="form-control form-control-sm" name="status[<?= esc($siswa['id']) ?>]">
                                        <?php foreach ($status_options as $option): ?>
                                            <option value="<?= esc($option) ?>" <?= $siswa['status_kenaikan'] == $option ? 'selected' : '' ?>>
                                                <?= esc($option) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <input type="hidden" name="kenaikan_id[<?= esc($siswa['id']) ?>]" value="<?= esc($siswa['id']) ?>">
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <button type="submit" class="btn btn-success mt-3" onclick="return confirm('Yakin ingin menyimpan semua koreksi status siswa di halaman ini? Proses ini akan menimpa data yang sudah ada.')">
                    <i class="fas fa-save"></i> Simpan Koreksi
                </button>
                <a href="<?= base_url('guru/siswa/naikKelas') ?>" class="btn btn-secondary mt-3 ml-2">
                    <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
                </a>
            </form>
            </div>
    </div>
</div>
<?= $this->endSection() ?>