<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>Daftar Tujuan Pembelajaran<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Daftar Tujuan Pembelajaran</h3>
        </div>
        <div class="card-body">
            <a href="<?= base_url('guru/tp_mapel/create') ?>" class="btn btn-primary mb-3">Tambah TP Baru</a>

            <?php if (session()->getFlashdata('success')) : ?>
                <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>
            <?php if (session()->getFlashdata('error')) : ?>
                <div class="alert alert-danger">
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($message)) : ?>
                <div class="alert alert-info"><?= esc($message) ?></div>
            <?php endif; ?>
            
            <?php if (isset($filter_semester)) : ?>
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="filterSemester">Lihat TP Semester:</label>
                    <select id="filterSemester" class="form-control" onchange="window.location.href = this.value;">
                        <?php $base_url = base_url('guru/tp_mapel'); ?>
                        
                        <option value="<?= $base_url ?>?semester=1" <?= ((string)$filter_semester === '1') ? 'selected' : '' ?>>Ganjil (1)</option>
                        <option value="<?= $base_url ?>?semester=2" <?= ((string)$filter_semester === '2') ? 'selected' : '' ?>>Genap (2)</option>
                        <option value="<?= $base_url ?>?semester=all" <?= ((string)$filter_semester === 'all') ? 'selected' : '' ?>>Semua Semester</option>
                    </select>
                </div>
            </div>
            <hr>
            <?php endif; ?>
            <?php if (!empty($kelas_guru)) : ?>
                <p>Anda terdaftar sebagai guru kelas untuk:
                    <?php $kelas_names = array_column($kelas_guru, 'nama_kelas'); ?>
                    <strong><?= implode(', ', array_map('esc', $kelas_names)) ?></strong>
                </p>
            <?php else : ?>
                <p class="alert alert-info">Anda tidak terdaftar sebagai guru kelas.</p>
            <?php endif; ?>

            <?php if (!empty($mapel_guru)) : ?>
                <p>Anda terdaftar mengampu mata pelajaran:
                    <?php $mapel_names = array_column($mapel_guru, 'nama_mapel'); ?>
                    <strong><?= implode(', ', array_map('esc', $mapel_names)) ?></strong>
                </p>
            <?php else : ?>
                <p class="alert alert-warning">Anda belum terdaftar mengampu mata pelajaran apapun.</p>
            <?php endif; ?>


            <?php if (empty($tp_mapel) && empty($message)) : ?>
                <div class="alert alert-info">Belum ada Tujuan Pembelajaran yang relevan untuk kelas dan mata pelajaran yang Anda ajar.</div>
            <?php elseif (!empty($tp_mapel)) : ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Mata Pelajaran</th>
                                <th>Kelas</th>
                                <th>Semester</th>
                                <th>Kode TP</th>
                                <th>Deskripsi TP</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; ?>
                            <?php foreach ($tp_mapel as $tp) : ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($tp['nama_mapel']) ?></td>
                                    <td><?= esc($tp['nama_kelas']) ?></td>
                                    <td>
                                        <?= esc(($tp['semester'] == 1) ? 'Ganjil' : 'Genap') ?>
                                    </td>
                                    <td><?= esc($tp['kode_tp']) ?></td>
                                    <td><?= esc($tp['deskripsi_tp']) ?></td>
                                    <td>
                                        <a href="<?= base_url('guru/tp_mapel/edit/' . $tp['id']) ?>" class="btn btn-primary mb-3">Edit</a>
                                        <a href="<?= base_url('guru/tp_mapel/delete/' . $tp['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus TP ini?');">Hapus</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?= $this->endSection() ?>