<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('admin/rentang_nilai/update'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Kategori</th>
                                <th>Nilai Minimal</th>
                                <th>Nilai Maksimal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($rentang_nilai as $rentang) : ?>
                                <tr>
                                    <td><?= esc($rentang['kategori']); ?></td>
                                    <td>
                                        <input type="number" class="form-control" name="rentang[<?= esc($rentang['id']); ?>][nilai_minimal]" value="<?= esc($rentang['nilai_minimal']); ?>">
                                    </td>
                                    <td>
                                        <input type="number" class="form-control" name="rentang[<?= esc($rentang['id']); ?>][nilai_maksimal]" value="<?= esc($rentang['nilai_maksimal']); ?>">
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <button type="submit" class="btn btn-primary mt-3">Simpan Perubahan</button>
					<a href="<?= base_url('admin/dashboard') ?>" class="btn btn-secondary">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>