<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title"><?= esc($title) ?></h3>
        <div class="card-tools">
            <a href="<?= base_url('admin/tahun_ajaran/new') ?>" class="btn btn-success btn-sm">Tambah Tahun Ajaran</a>
        </div>
    </div>
    <div class="card-body">
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>
        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Tahun Ajaran</th>
                    <th>Semester</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($tahun_ajaran)): ?>
                    <tr>
                        <td colspan="4" class="text-center">Belum ada data tahun ajaran.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($tahun_ajaran as $ta): ?>
                        <tr>
                            <td><?= esc($ta['nama_tahun']) ?></td>
                            <td><?= esc($ta['semester']) ?></td>
                            <td>
                                <?php if ($ta['aktif']): ?>
                                    <span class="badge bg-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Tidak Aktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (!$ta['aktif']): ?>
                                    <form action="<?= base_url('admin/tahun_ajaran/set_active/' . $ta['id']) ?>" method="post" style="display:inline;">
                                        <?= csrf_field() ?>
                                        <button type="submit" class="btn btn-primary btn-sm">Aktifkan</button>
                                    </form>
                                <?php endif; ?>
                                <a href="<?= base_url('admin/tahun_ajaran/edit/' . $ta['id']) ?>" class="btn btn-primary btn-sm">Edit</a>
                                <form action="<?= base_url('admin/tahun_ajaran/delete/' . $ta['id']) ?>" method="post" class="d-inline">
                                    <?= csrf_field() ?>
                                    <input type="hidden" name="_method" value="DELETE">
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Hapus</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this->endSection() ?>
