<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>Riwayat TP<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container">
    <div class="card">
        <div class="card-header bg-info text-white">
            <h3 class="card-title"><i class="fa fa-history"></i> Riwayat Semua Tujuan Pembelajaran</h3>
        </div>
        <div class="card-body">
            
            <form action="<?= base_url('guru/tp_mapel/riwayat') ?>" method="get" class="mb-4">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><i class="fa fa-calendar"></i> Tahun Ajaran:</label>
                            <select name="tahun" class="form-control" onchange="this.form.submit()">
                                <option value="">-- Semua Tahun --</option>
                                <?php foreach ($list_tahun as $th) : ?>
                                    <option value="<?= $th['id'] ?>" <?= ($filter_tahun == $th['id']) ? 'selected' : '' ?>>
                                        <?= esc($th['nama_tahun']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><i class="fa fa-list-ol"></i> Semester:</label>
                            <select name="semester" class="form-control" onchange="this.form.submit()">
                                <option value="">-- Semua Semester --</option>
                                <option value="1" <?= ($filter_semester == '1') ? 'selected' : '' ?>>Ganjil</option>
                                <option value="2" <?= ($filter_semester == '2') ? 'selected' : '' ?>>Genap</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <div class="form-group">
                            <a href="<?= base_url('guru/tp_mapel/riwayat') ?>" class="btn btn-secondary">
                                <i class="fa fa-eraser"></i> Reset Filter
                            </a>
                        </div>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
				<table class="table table-bordered table-hover">
					<thead class="thead-light">
						<tr>
							<th>No.</th>
							<th>Tahun Ajaran</th>
							<th>Mapel</th>
							<th>Kelas</th>
							<th>Smt</th>
							<th>Kode TP</th>
							<th>Deskripsi</th>
							<th class="text-center">Aksi</th> </tr>
					</thead>
					<tbody>
						<?php if (empty($tp_all)) : ?>
							<tr>
								<td colspan="8" class="text-center text-muted">Data tidak ditemukan.</td>
							</tr>
						<?php else : ?>
							<?php $no = 1; foreach ($tp_all as $tp) : ?>
								<tr>
									<td><?= $no++ ?></td>
									<td><strong><?= esc($tp['tahun_ajaran']) ?></strong></td>
									<td><?= esc($tp['nama_mapel']) ?></td>
									<td><?= esc($tp['nama_kelas']) ?></td>
									<td><?= ($tp['semester'] == 1) ? 'Ganjil' : 'Genap' ?></td>
									<td><span class="badge badge-secondary"><?= esc($tp['kode_tp']) ?></span></td>
									<td><?= esc($tp['deskripsi_tp']) ?></td>
									<td class="text-center">
										<a href="<?= base_url('guru/tp_mapel/copyToActive/' . $tp['id']) ?>" 
										   class="btn btn-success btn-sm" 
										   onclick="return confirm('Gunakan TP ini untuk Tahun Ajaran aktif saat ini?');"
										   title="Gunakan di Semester Aktif">
											<i class="fa fa-plus-circle"></i> Gunakan
										</a>
									</td>
								</tr>
							<?php endforeach; ?>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
            
            <a href="<?= base_url('guru/tp_mapel') ?>" class="btn btn-outline-primary mt-3">
                <i class="fa fa-arrow-left"></i> Kembali ke Daftar TP Aktif
            </a>
        </div>
    </div>
</div>
<?= $this->endSection() ?>