<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\RentangNilaiModel;

class RentangNilai extends BaseController
{
    protected $rentangNilaiModel;

    public function __construct()
    {
        $this->rentangNilaiModel = new RentangNilaiModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Pengaturan Rentang Nilai',
            'rentang_nilai' => $this->rentangNilaiModel->findAll()
        ];
        return view('admin/rentang_nilai/index', $data);
    }

    public function update()
    {
        $data_rentang = $this->request->getPost('rentang');

        if (empty($data_rentang)) {
            session()->setFlashdata('error', 'Tidak ada data yang dikirim.');
            return redirect()->to(base_url('admin/rentang_nilai'));
        }

        $db = \Config\Database::connect();
        $db->transBegin();

        try {
            foreach ($data_rentang as $id => $rentang) {
                $this->rentangNilaiModel->update($id, [
                    'nilai_minimal' => $rentang['nilai_minimal'],
                    'nilai_maksimal' => $rentang['nilai_maksimal']
                ]);
            }

            if ($db->transStatus() === false) {
                $db->transRollback();
                session()->setFlashdata('error', 'Gagal menyimpan data. Terjadi kesalahan pada database.');
            } else {
                $db->transCommit();
                session()->setFlashdata('success', 'Rentang nilai berhasil diperbarui.');
            }
        } catch (\Exception $e) {
            $db->transRollback();
            session()->setFlashdata('error', 'Gagal menyimpan data: ' . $e->getMessage());
        }

        return redirect()->to(base_url('admin/rentang_nilai'));
    }
}