<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>
<h1><?= esc($title) ?></h1>
<p>Isi formulir di bawah ini untuk menambahkan pengguna baru.</p>

<form action="<?= base_url('admin/users/save') ?>" method="post">
    <?= csrf_field() ?>

    <label for="username">Username:</label>
    <input type="text" id="username" name="username"
           value="<?= old('username') ?>"
           class="<?= ($validation->hasError('username')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('username')): ?>
        <p class="text-danger"><?= $validation->getError('username') ?></p>
    <?php endif; ?>
	<label>Minimal 4 karakter</label>
    <br><br>

    <label for="password">Password:</label>
    <input type="password" id="password" name="password"
           class="<?= ($validation->hasError('password')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('password')): ?>
        <p class="text-danger"><?= $validation->getError('password') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="password_confirm">Konfirmasi Password:</label>
    <input type="password" id="password_confirm" name="password_confirm"
           class="<?= ($validation->hasError('password_confirm')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('password_confirm')): ?>
        <p class="text-danger"><?= $validation->getError('password_confirm') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nama">Nama Lengkap:</label>
    <input type="text" id="nama" name="nama"
           value="<?= old('nama') ?>"
           class="<?= ($validation->hasError('nama')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('nama')): ?>
        <p class="text-danger"><?= $validation->getError('nama') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nip">NIP (Nomor Induk Pegawai - opsional):</label>
    <input type="text" id="nip" name="nip"
           value="<?= old('nip') ?>"
           class="<?= ($validation->hasError('nip')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nip')): ?>
        <p class="text-danger"><?= $validation->getError('nip') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="role">Role:</label>
    <select id="role" name="role"
            class="<?= ($validation->hasError('role')) ? 'is-invalid' : ''; ?>" required>
        <option value="">-- Pilih Role --</option>
        <option value="admin" <?= (old('role') == 'admin') ? 'selected' : '' ?>>Admin</option>
        <option value="guru" <?= (old('role') == 'guru') ? 'selected' : '' ?>>Guru</option>
        <option value="kepala_sekolah" <?= (old('role') == 'kepala_sekolah') ? 'selected' : '' ?>>Kepala Sekolah</option>
        </select>
    <?php if ($validation->hasError('role')): ?>
        <p class="text-danger"><?= $validation->getError('role') ?></p>
    <?php endif; ?>
    <br><br>

    <button type="submit" class="btn btn-success">Simpan Pengguna</button>
    <a href="<?= base_url('admin/users') ?>" class="btn btn-secondary">Batal</a>
</form>
<?= $this->endSection() ?>