<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>
<h1><?= esc($title) ?></h1>
<p>Isi formulir di bawah ini untuk mengubah data pengguna.</p>

<form action="<?= base_url('admin/users/update/' . $user['id']) ?>" method="post">
    <?= csrf_field() ?>

    <label for="username">Username:</label>
    <input type="text" id="username" name="username"
           value="<?= old('username', $user['username']) ?>"
           class="<?= ($validation->hasError('username')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('username')): ?>
        <p class="text-danger"><?= $validation->getError('username') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="password">Password Baru (kosongkan jika tidak ingin mengubah):</label>
    <input type="password" id="password" name="password"
           class="<?= ($validation->hasError('password')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('password')): ?>
        <p class="text-danger"><?= $validation->getError('password') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="password_confirm">Konfirmasi Password Baru:</label>
    <input type="password" id="password_confirm" name="password_confirm"
           class="<?= ($validation->hasError('password_confirm')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('password_confirm')): ?>
        <p class="text-danger"><?= $validation->getError('password_confirm') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nama">Nama Lengkap:</label>
    <input type="text" id="nama" name="nama"
           value="<?= old('nama', $user['nama']) ?>"
           class="<?= ($validation->hasError('nama')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('nama')): ?>
        <p class="text-danger"><?= $validation->getError('nama') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nip">NIP (Nomor Induk Pegawai - opsional):</label>
    <input type="text" id="nip" name="nip"
           value="<?= old('nip', $user['nip']) ?>"
           class="<?= ($validation->hasError('nip')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nip')): ?>
        <p class="text-danger"><?= $validation->getError('nip') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="role">Role:</label>
    <select id="role" name="role"
            class="<?= ($validation->hasError('role')) ? 'is-invalid' : ''; ?>" required>
        <option value="">-- Pilih Role --</option>
        <option value="admin" <?= (old('role', $user['role']) == 'admin') ? 'selected' : '' ?>>Admin</option>
        <option value="guru" <?= (old('role', $user['role']) == 'guru') ? 'selected' : '' ?>>Guru</option>
        <option value="kepala_sekolah" <?= (old('role', $user['role']) == 'kepala_sekolah') ? 'selected' : '' ?>>Kepala Sekolah</option>
        </select>
    <?php if ($validation->hasError('role')): ?>
        <p class="text-danger"><?= $validation->getError('role') ?></p>
    <?php endif; ?>
    <br><br>

    <button type="submit" class="btn btn-primary">Perbarui Pengguna</button>
    <a href="<?= base_url('admin/users') ?>" class="btn btn-secondary">Batal</a>
</form>
<?= $this->endSection() ?>