<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <form action="<?= base_url('guru/ekskul_wali_kelas/save_add'); ?>" method="post">
                    <?= csrf_field(); ?>
                    
                    <div class="form-group">
                        <label for="ekskul_id">Pilih Ekstrakurikuler (jika di kelas anda tidak ada Ekstra tersebut jangan dipilih/diisi)</label>
                        <select class="form-control" id="ekskul_id" name="ekskul_id" required>
                            <option value="">-- Pilih Ekskul --</option>
                            <?php foreach ($ekskul_list as $ekskul) : ?>
                                <option value="<?= $ekskul['id']; ?>"><?= esc($ekskul['nama_ekskul']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="siswa_id">Pilih Siswa</label>
                        <select class="form-control" id="siswa_id" name="siswa_id" required>
                            <option value="">-- Pilih Ekskul Terlebih Dahulu --</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="deskripsi_ekskul">Deskripsi Ekstrakurikuler</label>
                        <textarea class="form-control" id="deskripsi_ekskul" name="deskripsi_ekskul" rows="3" required></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('guru/ekskul_wali_kelas'); ?>" class="btn btn-secondary">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const ekskulSelect = document.getElementById('ekskul_id');
        const siswaSelect = document.getElementById('siswa_id');

        // Data yang dikirim dari Controller (diparsing dari JSON)
        const ALL_SISWA = <?= $all_siswa_json; ?>;
        const KELAS_SISWA = <?= $kelas_siswa_json; ?>; 
        
        // KOREKSI: Mengambil array ID Ekskul Wali Kelas
        const EKSKUL_WALI_KELAS_IDS = <?= $ekskul_wali_kelas_ids; ?>; // Array of integers
        const IS_WALI_KELAS = <?= json_encode($is_wali_kelas); ?>;

        /**
         * Mengisi dropdown siswa dengan data yang sesuai.
         */
        function populateSiswaDropdown(siswaList) {
            siswaSelect.innerHTML = '<option value="">-- Pilih Siswa --</option>';

            siswaList.forEach(siswa => {
                const option = document.createElement('option');
                option.value = siswa.id;
                option.textContent = `${siswa.nama_lengkap} (Kelas ${siswa.nama_kelas})`;
                siswaSelect.appendChild(option);
            });
        }
        
        /**
         * Logika utama filtering siswa berdasarkan Ekskul yang dipilih
         */
        function updateSiswaList() {
            // Pastikan nilai dikonversi menjadi integer
            const selectedEkskulId = parseInt(ekskulSelect.value); 
            let targetSiswaList = [];

            if (selectedEkskulId === 0 || isNaN(selectedEkskulId)) {
                // Jika belum memilih ekskul
                siswaSelect.innerHTML = '<option value="">-- Pilih Ekskul Terlebih Dahulu --</option>';
                return;
            }

            // KOREKSI: Cek apakah ID yang dipilih termasuk dalam array ID Ekskul Wali Kelas
            const isWaliKelasEkskulSelected = EKSKUL_WALI_KELAS_IDS.includes(selectedEkskulId);

            if (IS_WALI_KELAS && isWaliKelasEkskulSelected) {
                // KASUS 1: Ekskul Wali Kelas (salah satu dari yang NULL) terpilih OLEH WALI KELAS
                // Tampilkan HANYA siswa di kelas Wali
                targetSiswaList = KELAS_SISWA;
                
            } else {
                // KASUS 2: Ekskul non-Wali Kelas (atau Guru Agama/PJ Ekskul) terpilih
                // Tampilkan SEMUA siswa di sekolah
                targetSiswaList = ALL_SISWA;
            }

            populateSiswaDropdown(targetSiswaList);
        }

        // Event Listener untuk Ekskul dropdown
        ekskulSelect.addEventListener('change', updateSiswaList);

        // Inisialisasi: Bersihkan/atur pesan awal
        siswaSelect.innerHTML = '<option value="">-- Pilih Ekskul Terlebih Dahulu --</option>';
        
        // Panggil saat DOM dimuat jika ada nilai yang dipilih (untuk kasus error validasi/old data)
        if (ekskulSelect.value) {
            updateSiswaList();
        }
    });
</script>

<?= $this->endSection(); ?>