<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $this->renderSection('title') ? 'Guru | ' . $this->renderSection('title') : 'Guru Dashboard'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('css/kokurikuler.css') ?>">

    <style>
        :root {
            --sidebar-width-normal: 250px;
            --sidebar-width-minimized: 75px;
            --transition-speed: 0.3s;
        }

        aside, main, header {
            transition: all var(--transition-speed);
        }

        aside {
            width: var(--sidebar-width-normal);
        }

        main {
            margin-left: var(--sidebar-width-normal);
        }
        
        /* Modifikasi Struktur sidebar-header */
        .sidebar-header {
            padding: 15px;
            border-bottom: 1px solid #444; 
        }
        
        /* Wrapper untuk Title dan Toggle Button agar tetap horizontal */
        .title-and-toggle {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px; /* Jarak antara Title/Toggle dengan User Panel */
        }

        .sidebar-toggle-btn {
            background: none;
            border: none;
            color: #fff; 
            font-size: 1.5em;
            cursor: pointer;
            padding: 5px;
            line-height: 1;
        }
        
        /* State Ketika Sidebar Diminimalkan */
        body.sidebar-minimized aside {
            width: var(--sidebar-width-minimized);
        }

        body.sidebar-minimized main {
            margin-left: var(--sidebar-width-minimized);
        }

        /* Sembunyikan Judul dan User Panel saat minimal */
        body.sidebar-minimized .sidebar-header h6,
        body.sidebar-minimized .user-panel {
            display: none !important;
        }
        
        /* Posisikan tombol toggle di tengah saat sidebar minimal */
        body.sidebar-minimized .sidebar-header {
            padding: 15px 0; 
            text-align: center;
        }
        
        body.sidebar-minimized .title-and-toggle {
            justify-content: center;
        }
        
        /* Sembunyikan Teks pada Link Menu Sidebar */
        body.sidebar-minimized .sidebar-menu li a span {
            display: none;
        }

        /* Atur ulang Link Menu Sidebar agar ikon di tengah */
        body.sidebar-minimized .sidebar-menu li a {
            text-align: center;
            padding-left: 0;
            padding-right: 0;
            justify-content: center;
        }
        
        /* Hapus margin ikon agar ikon berada di tengah */
        body.sidebar-minimized .sidebar-menu li a i {
            margin-right: 0;
        }
    </style>
</head>
<body id="kokurikuler-layout">

    <header>
        <nav>
            <ul>
                <li><a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i> <span>Siswa Kelas Saya</span></a></li>
                <li><a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-book"></i> <span>Rapor</span></a></li>
                <li><a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></a></li>
            </ul>
        </nav>
    </header>

    <aside id="sidebar">
        <div class="sidebar-header">
            <div class="title-and-toggle">
                <h6><a class="sidebar-title">Kokurikuler SDN Degung</a></h6>
                <button id="sidebarToggle" class="sidebar-toggle-btn" title="Minimalkan Sidebar">
                    <i class="fas fa-bars"></i>
                </button>
            </div>

            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="info">
            <span class="d-block" style="color: #72c17e;">
                <strong>Halo, Sdr/i. <?= esc(session()->get('nama')); ?></strong>
            </span>
            </div>
            </div>
        </div>
        <ul class="sidebar-menu">
            <li><a href="<?= base_url('guru/kokurikuler') ?>"><i class="fas fa-clipboard-list"></i> <span>Manajemen Kokurikuler</span></a></li>
            <li><a href="<?= base_url('guru/penilaian_kokurikuler') ?>"><i class="fas fa-edit"></i> <span>Input Data</span></a></li>
			<li><a href="<?= base_url('guru/penilaian_kokurikuler/deskripsi') ?>"><i class="fas fa-file-signature"></i> <span>Hasil</span></a></li>
        </ul>
    </aside>

    <main id="main-content">
        <div class="content">
            <?= $this->renderSection('content') ?>
        </div>
        <footer>
            <p>&copy; <?= date('Y'); ?> E-Raport SDN Degung. All rights reserved.</p>
        </footer>
    </main>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        $(document).ready(function() {
            // Cek status sidebar dari local storage saat halaman dimuat
            if (localStorage.getItem('kokurSidebarState') === 'minimized') {
                $('body').addClass('sidebar-minimized');
            }

            $('#sidebarToggle').on('click', function(e) {
                e.preventDefault();
                
                // Toggle class pada body
                $('body').toggleClass('sidebar-minimized');
                
                // Simpan status ke local storage (gunakan key unik untuk kokurikuler)
                if ($('body').hasClass('sidebar-minimized')) {
                    localStorage.setItem('kokurSidebarState', 'minimized');
                } else {
                    localStorage.setItem('kokurSidebarState', 'normal');
                }
            });
        });
    </script>
</body>
</html>