<?php
// app/Helpers/tanggal_helper.php

if ( ! function_exists('tanggal_indonesia'))
{
    /**
     * Mengkonversi tanggal format 'd F Y' (Bahasa Inggris) ke Bahasa Indonesia.
     *
     * @param string $tanggal_en Tanggal dalam format Bahasa Inggris (e.g., '19 December 2025')
     * @return string Tanggal dalam format Bahasa Indonesia (e.g., '19 Desember 2025')
     */
    function tanggal_indonesia($tanggal_en)
    {
        $bulan = [
            'January'   => 'Januari',
            'February'  => 'Februari',
            'March'     => 'Maret',
            'April'     => 'April',
            'May'       => 'Mei',
            'June'      => 'Juni',
            'July'      => 'Juli',
            'August'    => 'Agustus',
            'September' => 'September',
            'October'   => 'Oktober',
            'November'  => 'November',
            'December'  => 'Desember'
        ];
        
        // strtr() lebih cepat dan efisien untuk banyak penggantian string.
        return strtr($tanggal_en, $bulan);
    }
}