<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('guru/ekskul_wali_kelas/save'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <div class="form-group">
                        <label for="tahun_ajaran">Tahun Ajaran</label>
                        <input type="text" class="form-control" value="<?= esc($tahun_ajaran['nama_tahun']) ?>" readonly>
                        <input type="hidden" name="tahun_ajaran_id" value="<?= esc($tahun_ajaran['id']) ?>">
                    </div>

                    <div class="form-group">
                        <label for="siswa_id">Pilih Siswa</label>
                        <select name="siswa_id" id="siswa_id" class="form-control" required>
                            <option value="">-- Pilih Siswa --</option>
                            <?php foreach ($siswa_list as $siswa) : ?>
                                <option value="<?= esc($siswa['id']) ?>"><?= esc($siswa['nama_lengkap']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="ekskul_id">Pilih Ekstrakurikuler</label>
                        <select name="ekskul_id" id="ekskul_id" class="form-control" required>
                            <option value="">-- Pilih Ekstrakurikuler --</option>
                            <?php foreach ($ekskul_master_list as $ekskul) : ?>
                                <option value="<?= esc($ekskul['id']) ?>"><?= esc($ekskul['nama_ekskul']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="deskripsi_ekskul">Deskripsi Kegiatan</label>
                        <textarea name="deskripsi_ekskul" id="deskripsi_ekskul" class="form-control" rows="3" required></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('guru/ekskul_wali_kelas'); ?>" class="btn btn-secondary">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
