<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>Edit Data Fisik Anak<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h1 class="card-title">Edit Data Fisik Anak</h1>
        </div>
        <div class="card-body">
            <form action="<?= base_url('guru/fisik_anak/update/' . $fisik_anak['id']) ?>" method="post">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')) : ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php foreach (session()->getFlashdata('errors') as $error) : ?>
                                <li><?= $error ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="mb-3">
                    <label for="siswa_id" class="form-label">Nama Siswa:</label>
                    <input type="text" class="form-control" value="<?= esc($siswa['nama_lengkap']) ?>" disabled>
                </div>
                <div class="mb-3">
                    <label for="berat_badan" class="form-label">Berat Badan (kg):</label>
                    <input type="number" step="0.01" class="form-control" id="berat_badan" name="berat_badan" value="<?= old('berat_badan', $fisik_anak['berat_badan']) ?>">
                </div>
                <div class="mb-3">
                    <label for="tinggi_badan" class="form-label">Tinggi Badan (cm):</label>
                    <input type="number" step="0.01" class="form-control" id="tinggi_badan" name="tinggi_badan" value="<?= old('tinggi_badan', $fisik_anak['tinggi_badan']) ?>">
                </div>
                
                <button type="submit" class="btn btn-primary">Perbarui</button>
                <a href="<?= base_url('guru/fisik_anak') ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>
<?= $this->endSection() ?>