<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <form action="<?= base_url('guru/penilaian/deskripsi'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="kelas_id">Kelas</label>
                                <select class="form-control" id="kelas_id" name="kelas_id" required>
                                    <option value="">-- Pilih Kelas --</option>
                                    <?php
                                    $unique_kelas = [];
                                    foreach ($guru_mapel_data as $gm) {
                                        if (!isset($unique_kelas[$gm['id_kelas']])) {
                                            $unique_kelas[$gm['id_kelas']] = $gm['nama_kelas'];
                                        }
                                    }
                                    ?>
                                    <?php foreach ($unique_kelas as $id_kelas => $nama_kelas) : ?>
                                        <option value="<?= esc($id_kelas); ?>" <?= ($selected_kelas_id == $id_kelas) ? 'selected' : ''; ?>>
                                            <?= esc($nama_kelas); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="mapel_id">Mata Pelajaran</label>
                                <select class="form-control" id="mapel_id" name="mapel_id" required>
                                    <option value="">-- Pilih Mapel --</option>
                                    <?php foreach ($guru_mapel_data as $gm) : ?>
                                        <option value="<?= esc($gm['mapel_id']); ?>" <?= ($selected_mapel_id == $gm['mapel_id']) ? 'selected' : ''; ?>>
                                            <?= esc($gm['nama_mapel']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="semester">Semester</label>
                                <select class="form-control" id="semester" name="semester" required>
                                    <option value="">-- Pilih Semester --</option>
                                    <option value="1" <?= ($selected_semester == '1') ? 'selected' : ''; ?>>1</option>
                                    <option value="2" <?= ($selected_semester == '2') ? 'selected' : ''; ?>>2</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="tahun_ajaran_id">Tahun Ajaran</label>
                                <select class="form-control" id="tahun_ajaran_id" name="tahun_ajaran_id" required>
                                    <option value="">-- Pilih Tahun Ajaran --</option>
                                    <?php foreach ($tahun_ajaran as $ta) : ?>
                                        <option value="<?= esc($ta['id']); ?>" <?= ($selected_tahun_ajaran_id == $ta['id']) ? 'selected' : ''; ?>>
                                            <?= esc($ta['nama_tahun']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary mt-3">Tampilkan</button>
                        </div>
                    </div>
                </form>

                <?php if (!empty($data_siswa)) : ?>
                    <hr>
                    <div id="deskripsi-table-container">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Lengkap</th>
                                    <th>Hasil Deskripsi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; ?>
                                <?php foreach ($data_siswa as $siswa) : ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($siswa['nama_lengkap']) ?></td>
                                        <td><?= $data_deskripsi[$siswa['id']]; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const kelasSelect = document.getElementById('kelas_id');
        const mapelSelect = document.getElementById('mapel_id');
        
        const guruMapelData = <?= json_encode($guru_mapel_data); ?>;

        function updateMapelOptions() {
            const selectedKelasId = kelasSelect.value;
            mapelSelect.innerHTML = '<option value="">-- Pilih Mata Pelajaran --</option>';

            const filteredMapels = guruMapelData.filter(item => item.id_kelas == selectedKelasId);
            
            const uniqueMapels = new Set();
            filteredMapels.forEach(item => {
                uniqueMapels.add(JSON.stringify({ id: item.mapel_id, nama_mapel: item.nama_mapel }));
            });

            Array.from(uniqueMapels).map(JSON.parse).sort((a, b) => a.nama_mapel.localeCompare(b.nama_mapel)).forEach(mapel => {
                const option = document.createElement('option');
                option.value = mapel.id;
                option.textContent = mapel.nama_mapel;
                
                if (mapel.id == '<?= esc($selected_mapel_id); ?>') {
                    option.selected = true;
                }
                mapelSelect.appendChild(option);
            });
        }

        if (kelasSelect.value) {
            updateMapelOptions();
        }

        kelasSelect.addEventListener('change', updateMapelOptions);
    });
</script>

<?= $this->endSection(); ?>