<?php

namespace App\Models;

use CodeIgniter\Model;

class GuruMapelModel extends Model
{
    protected $table      = 'guru_mapel';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false; // Sesuaikan jika Anda ingin menggunakan soft deletes

    protected $allowedFields = ['guru_id', 'mapel_id', 'id_kelas'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation (opsional, tapi disarankan)
    protected $validationRules    = [
        'guru_id'  => 'required|numeric',
        'mapel_id' => 'required|numeric',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;
}