<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <!-- Card Header with Title -->
    <div class="card-header">
        <h3 class="card-title"><?= esc($title) ?></h3>
    </div>
    
    <!-- Card Body contains the form -->
    <div class="card-body">
        <p>Isi formulir di bawah ini untuk mengubah data sekolah.</p>

				<form action="<?= base_url('admin/sekolah/update/' . $sekolah['id']) ?>" method="post">
			<?= csrf_field() ?>

			<label for="nama_sekolah">Nama Sekolah:</label>
			<input type="text" id="nama_sekolah" name="nama_sekolah" value="<?= old('nama_sekolah', $sekolah['nama_sekolah']) ?>">
			<br><br>

			<label for="nss">NSS (opsional):</label>
			<input type="text" id="nss" name="nss" value="<?= old('nss', $sekolah['nss']) ?>">
			<br><br>

			<label for="npsn">NPSN:</label>
			<input type="text" id="npsn" name="npsn" value="<?= old('npsn', $sekolah['npsn']) ?>">
			<br><br>

			<label for="alamat">Alamat:</label>
			<input type="text" id="alamat" name="alamat" value="<?= old('alamat', $sekolah['alamat']) ?>">
			<br><br>
			
			<label for="kode_pos">Kode Pos (opsional):</label>
			<input type="text" id="kode_pos" name="kode_pos" value="<?= old('kode_pos', $sekolah['kode_pos']) ?>">
			<br><br>
			
			<label for="telp">Telp (opsional):</label>
			<input type="text" id="telp" name="telp" value="<?= old('telp', $sekolah['telp']) ?>">
			<br><br>

			<label for="kelurahan_desa">Kelurahan/Desa:</label>
			<input type="text" id="kelurahan_desa" name="kelurahan_desa" value="<?= old('kelurahan_desa', $sekolah['kelurahan_desa']) ?>">
			<br><br>

			<label for="kapanewon">Kapanewon:</label>
			<input type="text" id="kapanewon" name="kapanewon" value="<?= old('kapanewon', $sekolah['kapanewon']) ?>">
			<br><br>

			<label for="kabupaten_kota">Kabupaten/Kota:</label>
			<input type="text" id="kabupaten_kota" name="kabupaten_kota" value="<?= old('kabupaten_kota', $sekolah['kabupaten_kota']) ?>">
			<br><br>

			<label for="provinsi">Provinsi:</label>
			<input type="text" id="provinsi" name="provinsi" value="<?= old('provinsi', $sekolah['provinsi']) ?>">
			<br><br>
			
			<label for="website">Website (opsional):</label>
			<input type="text" id="website" name="website" value="<?= old('website', $sekolah['website']) ?>">
			<br><br>

			<label for="email">Email (opsional):</label>
			<input type="email" id="email" name="email" value="<?= old('email', $sekolah['email']) ?>">
			<br><br>
			
			<label for="tempat_rapor">Tempat Rapor (opsional):</label>
			<input type="text" id="tempat_rapor" name="tempat_rapor" value="<?= old('tempat_rapor', $sekolah['tempat_rapor']) ?>">
			<br><br>

			<label for="tanggal_rapor">Tanggal Rapor (opsional):</label>
			<input type="date" id="tanggal_rapor" name="tanggal_rapor" value="<?= old('tanggal_rapor', $sekolah['tanggal_rapor']) ?>">
			<br><br>

			<label for="kepala_sekolah_id">Kepala Sekolah (opsional):</label>
			<select id="kepala_sekolah_id" name="kepala_sekolah_id">
				<option value="">-- Pilih Kepala Sekolah --</option>
				<?php foreach ($kepalaSekolahOptions as $ks): ?>
					<option value="<?= esc($ks['id']) ?>" <?= (old('kepala_sekolah_id', $sekolah['kepala_sekolah_id']) == $ks['id']) ? 'selected' : '' ?>>
						<?= esc($ks['nama']) ?> (<?= esc($ks['username']) ?>)
					</option>
				<?php endforeach; ?>
			</select>
			<br><br>

			<button class="btn btn-primary btn-sm" type="submit">Simpan Perubahan</button>
			<a href="<?= base_url('admin/sekolah') ?>" class="btn btn-secondary">Batal</a>
		</form>
    </div>
    <!-- End Card Body -->
</div>
<!-- End Card -->

<?= $this->endSection() ?>

