<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Cetak LJK - <?= $nama_siswa ?: 'Blanko'; ?></title>
    <style>
        body { font-family: Arial, sans-serif; padding: 0; margin: 0; color: #000; -webkit-print-color-adjust: exact; }
        
        .container-ljk { 
            position: relative; width: 210mm; height: 297mm; margin: auto;
            padding: 10mm; box-sizing: border-box;
        }

        /* --- UPDATE: Marker Sudut Diperkecil (10mm) --- */
        .marker { 
            width: 10mm; 
            height: 10mm; 
            background: #000; 
            position: absolute; 
        }
        /* Posisi tetap di pojok aman area cetak */
        .m-tl { top: 10mm; left: 10mm; } 
        .m-tr { top: 10mm; right: 10mm; }
        .m-bl { bottom: 10mm; left: 10mm; } 
        .m-br { bottom: 10mm; right: 10mm; }
        
        /* Header diturunkan sedikit (margin-top 25mm) agar tidak menabrak marker */
        .header-table { 
            width: 85%; 
            margin: 25mm auto 5mm auto; 
            border-bottom: 2px solid #000; 
            padding-bottom: 10px; 
        }
        
        /* --- Layout Soal (Tetap Sama) --- */
        .content-jawaban { display: flex; justify-content: center; gap: 15mm; margin-top: 10mm; }
        .column-jawaban { width: 45%; }

        .row-wrapper { display: flex; align-items: center; height: 7.5mm; margin-bottom: 4mm; }
        
        /* Timing Mark (Strip Samping) - Ukuran Tetap */
        .timing-mark { width: 8mm; height: 3mm; background: #000; margin-right: 4mm; }

        .nomor { width: 8mm; font-weight: bold; text-align: right; margin-right: 3mm; font-size: 14px; }
        
        .box { 
            width: 6mm; height: 6mm; border: 1.5px solid #000; 
            text-align: center; line-height: 6mm; margin-right: 3mm; 
            font-size: 11px; font-weight: bold; 
        }

        @media print {
            @page { size: A4; margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">

    <div class="container-ljk">
        <div class="marker m-tl"></div><div class="marker m-tr"></div>
        <div class="marker m-bl"></div><div class="marker m-br"></div>

        <table class="header-table">
            <tr>
                <td width="70%">
                    <h2 style="margin:0;">LJK KOMPUTER (A-D)</h2>
                    <table style="font-weight:bold; margin-top:5px;">
                        <tr><td>NAMA</td><td>: <?= strtoupper($nama_siswa ?: '............................'); ?></td></tr>
                        <tr><td>KELAS</td><td>: <?= strtoupper($kelas_nama ?? '..........'); ?></td></tr>
                        <tr><td>MAPEL</td><td>: <?= strtoupper($mapel ?: '..........'); ?></td></tr>
                    </table>
                </td>
                <td width="30%" align="center">
                    <?php 
                        $isi_qr = trim($nama_siswa)."|".trim($kelas_nama)."|".trim($mapel);
                        $url_qr = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($isi_qr);
                    ?>
                    <img src="<?= $url_qr ?>" style="width: 25mm; height: 25mm; border: 2px solid #000;">
                </td>
            </tr>
        </table>

        <?php
            $total_soal = isset($jumlah_soal) ? (int)$jumlah_soal : 20;
            $mid_point = ceil($total_soal / 2);
        ?>

        <div class="content-jawaban">
            <div class="column-jawaban">
                <?php for($i=1; $i<=$mid_point; $i++): ?>
                    <div class="row-wrapper">
                        <div class="timing-mark"></div>
                        <div class="nomor"><?= $i ?>.</div>
                        <div class="box">A</div><div class="box">B</div>
                        <div class="box">C</div><div class="box">D</div>
                    </div>
                <?php endfor; ?>
            </div>

            <div class="column-jawaban">
                <?php for($i=$mid_point+1; $i<=$total_soal; $i++): ?>
                    <div class="row-wrapper">
                        <div class="timing-mark"></div>
                        <div class="nomor"><?= $i ?>.</div>
                        <div class="box">A</div><div class="box">B</div>
                        <div class="box">C</div><div class="box">D</div>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
    </div>
</body>
</html>