<?= $this->extend('layout/guru_layout'); ?>
<?= $this->section('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-6 mx-auto">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title"><i class="fas fa-print"></i> Cetak Lembar LJK</h3>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('guru/ljk/cetak'); ?>" method="post" target="_blank">
                        <?= csrf_field(); ?>
                        
                        <input type="hidden" name="kelas_nama" id="kelas_nama">

                        <div class="form-group mb-3">
                            <label><b>Pilih Kelas</b></label>
                            <select name="kelas_id" id="pilih_kelas" class="form-control" required>
                                <option value="">-- Pilih Kelas --</option>
                                <?php foreach($kelas as $k): ?>
                                    <option value="<?= $k['id_kelas']; ?>"><?= $k['nama_kelas']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group mb-3">
                            <label><b>Pilih Siswa</b></label>
                            <select name="nama_siswa" id="pilih_siswa" class="form-control">
                                <option value="">-- Semua Siswa (Kertas Kosong) --</option>
                            </select>
                        </div>

                        <div class="form-group mb-3">
                            <label><b>Mata Pelajaran</b></label>
                            <select name="mapel" class="form-control" required>
                                <?php foreach($mapel as $m): ?>
                                    <option value="<?= $m['nama_mapel']; ?>"><?= $m['nama_mapel']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group mb-4">
                            <label><b>Jumlah Soal</b></label>
                            <select name="jumlah_soal" class="form-control">
                                <option value="20">20 Soal</option>
                                <option value="40">40 Soal</option>
                            </select>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="<?= base_url('guru/ljk/kunci'); ?>" class="btn btn-success px-5">
                                <i class="fas fa-key"></i> Atur Kunci
                            </a>
                            
							<button type="submit" class="btn btn-success px-5">
                                <i class="fas fa-file-pdf"></i> Generate LJK
                            </button>
						</div>
							<a href="<?= base_url('guru/ljk/scan'); ?>" class="btn btn-success px-5">
                                <i class="fas fa-key"></i> Scan
                            </a>
					</form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('pilih_kelas').addEventListener('change', function() {
    const idKelas = this.value;
    const inputKelasNama = document.getElementById('kelas_nama');
    const siswaSelect = document.getElementById('pilih_siswa');

    // MENGAMBIL TEKS NAMA KELAS (Contoh: "Kelas 10-A")
    // Bukan sekedar ID (Contoh: "1")
    if (this.selectedIndex > 0) {
        const namaKelasDipilih = this.options[this.selectedIndex].text;
        inputKelasNama.value = namaKelasDipilih;
        console.log("Nama Kelas yang akan dicetak: " + namaKelasDipilih);
    } else {
        inputKelasNama.value = "";
    }
    
    // Reset & Loading Siswa
    siswaSelect.innerHTML = '<option value="">-- Loading data siswa... --</option>';
    
    if (idKelas) {
        fetch('<?= site_url('guru/ljk/getSiswa'); ?>/' + idKelas)
            .then(response => response.json())
            .then(data => {
                siswaSelect.innerHTML = '<option value="">-- Semua Siswa (Kertas Kosong) --</option>';
                data.forEach(siswa => {
                    // Pastikan field sesuai dengan database Anda (nama_lengkap)
                    if(siswa.nama_lengkap) {
                        let option = document.createElement('option');
                        option.value = siswa.nama_lengkap;
                        option.text = siswa.nama_lengkap;
                        siswaSelect.appendChild(option);
                    }
                });
            })
            .catch(error => {
                console.error('Error:', error);
                siswaSelect.innerHTML = '<option value="">-- Gagal memuat data --</option>';
            });
    } else {
        siswaSelect.innerHTML = '<option value="">-- Pilih Kelas Terlebih Dahulu --</option>';
    }
});
</script>

<?= $this->endSection(); ?>