<?= $this->extend('layout/guru_layout'); ?>
<?= $this->section('content'); ?>

<style>
    /* --- CONTAINER UTAMA --- */
    .scanner-wrapper { 
        position: relative; 
        width: 100%; 
        background: #000; 
        border-radius: 12px; 
        overflow: hidden; 
        box-shadow: 0 10px 25px rgba(0,0,0,0.5);
    }

    #canvasOutput { 
        width: 100%; 
        height: auto; 
        display: block; 
    }

    /* --- OVERLAY PANDUAN BARU --- */
    .overlay-layer { 
        position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events: none; 
    }

    /* 1. Garis Strip Kiri (Start) */
    .guide-line-left {
        position: absolute; top: 0; bottom: 0;
        left: 10%; /* Agak menjorok ke dalam supaya enak dilihat */
        width: 4px;
        background: rgba(0, 255, 0, 0.8);
        box-shadow: 0 0 10px rgba(0,255,0,0.5);
    }
    
    /* 2. Garis Strip Tengah (Pembatas Kolom 1 & 2) */
    .guide-line-mid {
        position: absolute; top: 0; bottom: 0;
        left: 60%; /* Posisi Strip Tengah LJK biasanya di sini */
        width: 4px;
        border-left: 2px dashed rgba(0, 255, 0, 0.8);
    }

    /* 3. Kotak Visual Kolom Kanan (Supaya user tahu kertasnya sampai sini) */
    .guide-area-right {
        position: absolute; top: 5%; bottom: 5%;
        left: 60%; right: 5%; /* Area sisa di sebelah kanan */
        border: 2px dashed rgba(255, 255, 255, 0.3);
        border-radius: 0 10px 10px 0;
        display: flex; align-items: center; justify-content: center;
    }
    .guide-label {
        color: rgba(255,255,255,0.5); font-weight: bold; font-size: 1.5rem;
        transform: rotate(90deg); letter-spacing: 5px;
    }

    .instruction-text {
        position: absolute; bottom: 20px; left: 0; right: 0;
        text-align: center; color: #fff; font-size: 14px;
        text-shadow: 2px 2px 4px #000;
        background: rgba(0,0,0,0.7); padding: 10px;
    }
</style>

<div class="row">
    <div class="col-lg-8">
        <div class="scanner-wrapper">
            <video id="videoInput" style="display:none;"></video>
            <canvas id="canvasOutput"></canvas>
            
            <div class="overlay-layer">
                <div class="guide-line-left"></div>
                
                <div class="guide-line-mid"></div>

                <div class="guide-area-right">
                    <span class="guide-label">KOLOM 2</span>
                </div>

                <div class="instruction-text">
                    Luruskan <b>Strip Kiri</b> di Garis Hijau & <b>Strip Tengah</b> di Garis Putus.
                </div>
            </div>
        </div>
        
        <div class="alert alert-info mt-3 shadow-sm py-2">
            <i class="fas fa-magic"></i> <b>Auto-Zoom:</b> Anda boleh mendekatkan HP agar LJK terlihat besar, asalkan kedua strip (Kiri & Tengah) tetap terlihat.
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card shadow border-0" style="border-radius: 12px;">
            <div class="card-header bg-primary text-white">
                <h6 class="m-0 font-weight-bold"><i class="fas fa-poll-h"></i> Hasil Scan</h6>
            </div>
            <div class="card-body p-3">
                <table class="table table-sm table-borderless mb-2">
                    <tr><td class="text-muted">Siswa</td><td id="res-nama" class="font-weight-bold text-dark">-</td></tr>
                    <tr><td class="text-muted">Mapel</td><td id="res-mapel" class="font-weight-bold text-dark">-</td></tr>
                </table>
                
                <hr class="my-2">
                
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <span class="text-muted font-weight-bold">SKOR:</span>
                    <h2 id="res-skor" class="m-0 font-weight-bold text-primary">-</h2>
                </div>
                
                <div id="status-text" class="text-center small font-weight-bold text-secondary mb-3">Siapkan Kamera...</div>

                <button id="btn-lock" class="btn btn-warning btn-block font-weight-bold shadow-sm py-3" onclick="toggleLock()">
                    <i class="fas fa-camera"></i> SCAN SEKARANG
                </button>
                <button id="btn-simpan" class="btn btn-success btn-block font-weight-bold shadow-sm py-2" disabled onclick="simpanKeDatabase()">
                    <i class="fas fa-save"></i> SIMPAN DATA
                </button>
            </div>
        </div>
    </div>
</div>

<script async src="https://docs.opencv.org/4.5.4/opencv.js" onload="onOpenCvReady();"></script>
<script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.min.js"></script>

<script>
    let video = document.getElementById('videoInput');
    let canvas = document.getElementById('canvasOutput');
    let ctx = canvas.getContext('2d', { willReadFrequently: true });
    
    let stream = null;
    let streaming = false;
    let isLocked = false;

    // --- KONFIGURASI PENCARIAN (Relative Screen %) ---
    // Area pencarian diperlebar agar lebih mudah mendeteksi strip
    const SEARCH_LEFT_X = 0.10; // Cari strip kiri di sekitar 10% lebar layar
    const SEARCH_MID_X  = 0.60; // Cari strip tengah di sekitar 60% lebar layar
    const SEARCH_WIDTH  = 180;  // Lebar area pencarian (px) - Lebih lebar = Lebih toleran

    function onOpenCvReady() {
        // Minta resolusi tinggi agar detail terbaca
        let constraints = { 
            video: { 
                facingMode: "environment",
                width: { ideal: 1920 }, // Coba Full HD
                height: { ideal: 1080 } 
            } 
        };

        navigator.mediaDevices.getUserMedia(constraints)
        .then(function(s) {
            stream = s;
            video.srcObject = stream;
            video.play();
            streaming = true;
            requestAnimationFrame(processFrame);
        })
        .catch(function(err) {
            alert("Gagal akses kamera: " + err);
        });
    }

    function processFrame() {
        if (!streaming || isLocked) return;

        // Resize Canvas sesuai Video (Anti-Gepeng)
        if (video.videoWidth > 0 && canvas.width !== video.videoWidth) {
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
        }

        ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
        
        // Scan QR Code Identitas
        let imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
        let code = jsQR(imageData.data, imageData.width, imageData.height);
        
        if (code && code.data) {
            let data = code.data.split('|');
            if(data.length >= 3) {
                if(document.getElementById('res-nama').innerText !== data[0]) {
                    document.getElementById('res-nama').innerText = data[0];
                    document.getElementById('res-mapel').innerText = data[2];
                    
                    // Visualisasi Kotak QR
                    ctx.beginPath();
                    ctx.lineWidth = 5;
                    ctx.strokeStyle = "#00FF00";
                    ctx.rect(code.location.topLeftCorner.x, code.location.topLeftCorner.y, code.width, code.height);
                    ctx.stroke();
                }
            }
        }
        requestAnimationFrame(processFrame);
    }

    function toggleLock() {
        isLocked = !isLocked;
        let btnLock = document.getElementById('btn-lock');
        let statusTxt = document.getElementById('status-text');

        if (isLocked) {
            btnLock.className = "btn btn-danger btn-block font-weight-bold shadow-sm py-3";
            btnLock.innerHTML = "<i class='fas fa-sync'></i> ULANGI SCAN";
            statusTxt.innerText = "Menganalisis Jawaban...";
            statusTxt.className = "text-center small font-weight-bold text-primary mb-3";
            calculateAnswers();
        } else {
            btnLock.className = "btn btn-warning btn-block font-weight-bold shadow-sm py-3";
            btnLock.innerHTML = "<i class='fas fa-camera'></i> SCAN SEKARANG";
            statusTxt.innerText = "Siapkan Kamera...";
            statusTxt.className = "text-center small font-weight-bold text-secondary mb-3";
            document.getElementById('res-skor').innerText = "-";
            document.getElementById('btn-simpan').disabled = true;
            requestAnimationFrame(processFrame);
        }
    }

    function calculateAnswers() {
        if(document.getElementById('res-nama').innerText === "-") {
            alert("QR Code Siswa belum terbaca! Scan QR dulu.");
            toggleLock(); return;
        }

        let src = cv.imread(canvas);
        let gray = new cv.Mat();
        
        // 1. Preprocessing Citra
        cv.cvtColor(src, gray, cv.COLOR_RGBA2GRAY);
        // Adaptive Threshold untuk mengatasi pencahayaan tidak rata
        cv.adaptiveThreshold(gray, gray, 255, cv.ADAPTIVE_THRESH_GAUSSIAN_C, cv.THRESH_BINARY_INV, 21, 10);

        let width = canvas.width;
        let height = canvas.height;
        let leftMarks = [], rightMarks = [];

        // 2. Cari Strip Hitam (Timing Marks)
        // Kita cari di dua area: Kiri (10%) dan Tengah (60%)
        let configs = [
            { xPct: SEARCH_LEFT_X, target: leftMarks },
            { xPct: SEARCH_MID_X, target: rightMarks }
        ];

        configs.forEach(conf => {
            let roiX = Math.floor(conf.xPct * width);
            let roiW = SEARCH_WIDTH;
            
            // Safety check batas canvas
            if(roiX + roiW > width) roiX = width - roiW;
            if(roiX < 0) roiX = 0;

            let roiRect = new cv.Rect(roiX, 0, roiW, height);
            let roi = gray.roi(roiRect);
            
            let contours = new cv.MatVector();
            let hierarchy = new cv.Mat();
            cv.findContours(roi, contours, hierarchy, cv.RETR_EXTERNAL, cv.CHAIN_APPROX_SIMPLE);

            for (let i = 0; i < contours.size(); i++) {
                let rect = cv.boundingRect(contours.get(i));
                // Filter bentuk Strip: Lebar > Tinggi, dan Ukuran wajar
                let ratio = rect.width / rect.height;
                if (rect.width > 15 && rect.height > 5 && ratio > 1.2) {
                    conf.target.push({
                        x: roiX + rect.x,
                        y: rect.y,
                        h: rect.height,
                        w: rect.width
                    });
                    // Visualisasi Debug (Garis Kuning tipis di marks yang ketemu)
                    cv.rectangle(src, new cv.Point(roiX + rect.x, rect.y), 
                                      new cv.Point(roiX + rect.x + rect.width, rect.y + rect.height), 
                                      [255, 255, 0, 255], 1);
                }
            }
            roi.delete(); contours.delete(); hierarchy.delete();
        });

        // Urutkan marks dari atas ke bawah
        leftMarks.sort((a, b) => a.y - b.y);
        rightMarks.sort((a, b) => a.y - b.y);

        // --- 3. AUTO-SCALING LOGIC (FITUR UTAMA) ---
        // Menghitung skala berdasarkan jarak rata-rata antara Strip Kiri dan Strip Tengah
        if(leftMarks.length > 0 && rightMarks.length > 0) {
            // Ambil sampel X rata-rata
            let avgLeftX = leftMarks.reduce((a,b)=>a+b.x,0) / leftMarks.length;
            let avgRightX = rightMarks.reduce((a,b)=>a+b.x,0) / rightMarks.length;
            
            // Jarak Kolom (Width of Column 1)
            let columnWidth = avgRightX - avgLeftX;
            
            // Rasio Geometri Standar LJK (Dihitung manual dari kertas A4)
            // Jarak Mark ke A = 13% dari lebar kolom
            // Jarak antar opsi (A ke B) = 11% dari lebar kolom
            let offsetA = columnWidth * 0.135; 
            let gapOption = columnWidth * 0.11; 

            // Proses Kolom 1 (Kiri) & Kolom 2 (Kanan)
            let jawabanSiswa = {};

            // --- FUNGSI DETEKSI ---
            const processMarks = (marks, startNum) => {
                marks.forEach((mark, idx) => {
                    let nomorSoal = startNum + idx;
                    let centerY = mark.y + (mark.h / 2);
                    
                    let maxWhite = 0;
                    let terpilih = "-";
                    let opsi = ['A', 'B', 'C', 'D'];

                    opsi.forEach((huruf, iOpsi) => {
                        // Posisi dinamis berdasarkan Scale
                        let boxX = mark.x + offsetA + (iOpsi * gapOption);
                        let boxY = centerY - (mark.h * 0.8); // Sedikit ke atas mark
                        let boxSize = gapOption * 0.6; // Ukuran kotak periksa

                        // Validasi batas
                        if (boxX + boxSize < width && boxY + boxSize < height && boxX > 0 && boxY > 0) {
                            let rect = new cv.Rect(boxX, boxY, boxSize, boxSize);
                            let roiBox = gray.roi(rect);
                            let whitePixels = cv.countNonZero(roiBox);
                            roiBox.delete();

                            // Visualisasi Area Periksa (Kotak Biru Tipis)
                            cv.rectangle(src, new cv.Point(boxX, boxY), 
                                              new cv.Point(boxX+boxSize, boxY+boxSize), 
                                              [0, 255, 255, 100], 1);

                            // Ambang batas (Threshold) piksel putih
                            // Jika banyak putih = ada coretan silang (X)
                            // Angka 40 ini toleransi sensitivitas
                            if (whitePixels > maxWhite && whitePixels > (boxSize*boxSize * 0.25)) {
                                maxWhite = whitePixels;
                                terpilih = huruf;
                                // Visualisasi Jawaban Ketemu (Kotak Hijau Tebal)
                                cv.rectangle(src, new cv.Point(boxX, boxY), 
                                                  new cv.Point(boxX+boxSize, boxY+boxSize), 
                                                  [0, 255, 0, 255], 3);
                            }
                        }
                    });
                    jawabanSiswa[nomorSoal] = terpilih;
                });
            };

            processMarks(leftMarks, 1);
            // Kolom kanan start nomornya lanjut dari jumlah mark kiri
            processMarks(rightMarks, leftMarks.length + 1);

            // Tampilkan hasil visual di layar
            cv.imshow(canvas, src);
            kirimKeServer(jawabanSiswa);

        } else {
            alert("Gagal mendeteksi struktur LJK. Pastikan cahaya terang dan kertas tidak melengkung.");
            toggleLock();
        }

        src.delete(); gray.delete();
    }

    function kirimKeServer(jawabanJson) {
        let mapel = document.getElementById('res-mapel').innerText.trim();
        
        fetch('<?= base_url('guru/ljk/hitung_nilai'); ?>', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                jawaban: jawabanJson,
                mapel: mapel
            })
        })
        .then(res => res.json())
        .then(data => {
            if(data.status == 'success') {
                document.getElementById('res-skor').innerText = data.skor;
                document.getElementById('status-text').innerText = "SUKSES DIHITUNG!";
                document.getElementById('status-text').className = "text-center small font-weight-bold text-success mb-3";
                document.getElementById('btn-simpan').disabled = false;
            } else {
                document.getElementById('res-skor').innerText = "Err";
                document.getElementById('status-text').innerText = data.msg || "Gagal Hitung";
                document.getElementById('status-text').className = "text-center small font-weight-bold text-danger mb-3";
            }
        })
        .catch(e => {
            console.error(e);
            document.getElementById('status-text').innerText = "Koneksi Error";
        });
    }

    function simpanKeDatabase() {
        alert("Data Tersimpan!");
        window.location.reload();
    }
</script>

<?= $this->endSection(); ?>