<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>

<style>
    /* CSS UNTUK TAMPILAN KARTU HP AGAR TIDAK MENUMPUK */
    @media (max-width: 768px) {
        .table-penilaian, .table-penilaian tbody, .table-penilaian tr, .table-penilaian td {
            display: block !important;
            width: 100% !important;
            position: relative !important;
            padding: 0 !important;
        }
        .table-penilaian thead { display: none; }
        .table-penilaian tr {
            margin-bottom: 20px;
            border: 1px solid #28a745 !important;
            border-radius: 10px;
            overflow: hidden;
            background: #fff;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .nama-siswa-cell {
            background-color: #e8f5e9 !important;
            color: #2e7d32 !important;
            font-weight: bold !important;
            padding: 12px !important;
            text-align: center !important;
            border-bottom: 2px solid #28a745 !important;
        }
        .table-penilaian td:not(.nama-siswa-cell) {
            display: flex !important;
            justify-content: space-between !important;
            align-items: center !important;
            padding: 10px 15px !important;
            border-bottom: 1px solid #eee !important;
        }
        .table-penilaian td:before {
            content: attr(data-label);
            position: static !important;
            font-weight: bold;
            color: #555;
            font-size: 0.85rem;
        }
        .input-nilai-mobile {
            width: 85px !important;
            text-align: center;
        }
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show"><?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('guru/penilaian/index'); ?>" method="post" class="mb-4">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-3">
                            <label>Kelas</label>
                            <select class="form-control" name="kelas_id" required>
                                <option value="">-- Pilih --</option>
                                <?php $unique_kelas = []; foreach ($guru_mapel_data as $gm) { if (!isset($unique_kelas[$gm['id_kelas']])) { $unique_kelas[$gm['id_kelas']] = $gm['nama_kelas']; } } ?>
                                <?php foreach ($unique_kelas as $id => $nama) : ?>
                                    <option value="<?= $id; ?>" <?= ($selected_kelas_id == $id) ? 'selected' : ''; ?>><?= $nama; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Mapel</label>
                            <select class="form-control" name="mapel_id" required>
                                <option value="">-- Pilih --</option>
                                <?php foreach ($guru_mapel_data as $gm) : ?>
                                    <option value="<?= $gm['mapel_id']; ?>" <?= ($selected_mapel_id == $gm['mapel_id']) ? 'selected' : ''; ?>><?= $gm['nama_mapel']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Semester</label>
                            <select name="semester" class="form-control">
                                <option value="1" <?= ($selected_semester == '1') ? 'selected' : ''; ?>>Ganjil</option>
                                <option value="2" <?= ($selected_semester == '2') ? 'selected' : ''; ?>>Genap</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Tahun Ajaran</label>
                            <select name="tahun_ajaran_id" class="form-control" required>
                                <?php foreach ($tahun_ajaran as $ta) : ?>
                                    <option value="<?= $ta['id']; ?>" <?= ($ta['id'] == $selected_tahun_ajaran_id) ? 'selected' : ''; ?>><?= $ta['nama_tahun']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary btn-block">Cari</button>
                        </div>
                    </div>
                </form>

                <?php if (!empty($data_siswa)) : ?>
                <form action="<?= base_url('guru/penilaian/process'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <input type="hidden" name="kelas_id" value="<?= $selected_kelas_id; ?>">
                    <input type="hidden" name="mapel_id" value="<?= $selected_mapel_id; ?>">
                    <input type="hidden" name="semester" value="<?= $selected_semester; ?>">
                    <input type="hidden" name="tahun_ajaran_id" value="<?= $selected_tahun_ajaran_id; ?>">

                    <table class="table table-bordered table-penilaian">
                        <thead class="thead-light">
                            <tr>
                                <th>Nama Siswa</th>
                                <?php foreach ($tp_mapel_list as $tp) : ?><th><?= $tp['kode_tp']; ?></th><?php endforeach; ?>
                                <th>PTS</th><th>PAS</th><th class="bg-info text-white">NA</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($data_siswa as $siswa) : ?>
                            <tr class="siswa-row">
                                <td class="nama-siswa-cell" data-label="SISWA"><?= esc($siswa['nama_lengkap']); ?></td>
                                <?php foreach ($tp_mapel_list as $tp) : ?>
                                <td data-label="NILAI <?= $tp['kode_tp']; ?>">
                                    <input type="number" step="0.01" class="form-control input-nilai-mobile input-harian" 
                                        name="nilai[<?= $siswa['id']; ?>][Harian][<?= $tp['id']; ?>]" 
                                        value="<?= $data_penilaian[$siswa['id']]['harian'][$tp['id']] ?? ''; ?>">
                                </td>
                                <?php endforeach; ?>
                                <td data-label="NILAI PTS"><input type="number" step="0.01" class="form-control input-nilai-mobile input-pts" name="nilai[<?= $siswa['id']; ?>][PTS/STS]" value="<?= $data_penilaian[$siswa['id']]['pts'] ?? ''; ?>"></td>
                                <td data-label="NILAI PAS"><input type="number" step="0.01" class="form-control input-nilai-mobile input-pas" name="nilai[<?= $siswa['id']; ?>][PAS/SAS]" value="<?= $data_penilaian[$siswa['id']]['pas'] ?? ''; ?>"></td>
                                <td data-label="NA" class="font-weight-bold text-center"><span class="nilai-akhir-display">0.00</span></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <div class="mt-4">
						<button type="submit" class="btn btn-primary btn-lg btn-block mb-3 shadow">
							<i class="fas fa-save mr-2"></i> SIMPAN SEMUA NILAI
						</button>
					</form> <div class="row">
						<div class="col-md-6 mb-2">
							<form action="<?= base_url('guru/penilaian/hitungNilaiAkhir'); ?>" method="get">
								<input type="hidden" name="kelas_id" value="<?= esc($selected_kelas_id); ?>">
								<input type="hidden" name="mapel_id" value="<?= esc($selected_mapel_id); ?>">
								<input type="hidden" name="semester" value="<?= esc($selected_semester); ?>">
								<input type="hidden" name="tahun_ajaran_id" value="<?= esc($selected_tahun_ajaran_id); ?>">
								<button type="submit" class="btn btn-success btn-block shadow-sm">
									<i class="fas fa-list mr-2"></i> Lihat Rekap Nilai Akhir
								</button>
							</form>
						</div>
						<div>
						<h6> </h6>
						</div>
						<div class="col-md-6 mb-2">
							<form action="<?= base_url('guru/penilaian/finalisasi') ?>" method="post" onsubmit="return confirm('Apakah Anda yakin ingin memfinalisasi semua nilai akhir rapor untuk semester ini? Proses ini akan menyimpan nilai secara permanen.');" style="display:inline;">
								<?= csrf_field(); ?>
								<button type="submit" class="btn btn-success mb-3">
									<i class="fas fa-check-circle"></i> Finalisasi Nilai Rapor
								</button>
							</form>
						</div>
					</div>
                </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        function calculateFinalGrade(row) {
            const harianInputs = row.querySelectorAll('.input-harian');
            const ptsInput = row.querySelector('.input-pts');
            const pasInput = row.querySelector('.input-pas');
            const display = row.querySelector('.nilai-akhir-display');

            let totalHarian = 0, countHarian = 0;
            harianInputs.forEach(input => {
                let val = parseFloat(input.value);
                if (!isNaN(val)) { totalHarian += val; countHarian++; }
            });

            const rerataHarian = countHarian > 0 ? (totalHarian / countHarian) : 0;
            const pts = parseFloat(ptsInput.value) || 0;
            const pas = parseFloat(pasInput.value) || 0;

            let nilaiAkhir = (countHarian > 0 || pts > 0 || pas > 0) ? (rerataHarian + pts + pas) / 3 : 0;
            display.innerText = nilaiAkhir.toFixed(2);
        }

        document.querySelectorAll('input[type="number"]').forEach(input => {
            input.addEventListener('input', () => calculateFinalGrade(input.closest('.siswa-row')));
        });
        document.querySelectorAll('.siswa-row').forEach(row => calculateFinalGrade(row));
    });
</script>

<?= $this->endSection(); ?>