<?= $this->extend('layout/kokurikuler_layout'); ?> 

<?= $this->section('content'); ?>

<style>
    /* Style khusus untuk tampilan kartu di HP */
    .card-siswa {
        border: 1px solid #ddd;
        border-radius: 10px;
        background: #fff;
        padding: 15px;
        margin-bottom: 20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .nama-siswa {
        font-weight: bold;
        color: #007bff;
        font-size: 1.1rem;
        border-bottom: 2px solid #f0f0f0;
        padding-bottom: 8px;
        margin-bottom: 12px;
        display: block;
    }
    .label-dimensi {
        font-size: 0.9rem;
        color: #555;
        display: block;
        margin-bottom: 5px;
    }
    .tema-badge {
        font-size: 0.75rem;
        padding: 3px 8px;
        border-radius: 4px;
        margin-bottom: 10px;
        display: inline-block;
    }
    /* Sembunyikan tabel asli di layar kecil */
    @media (max-width: 767.98px) {
        .table-responsive-desktop { display: none; }
    }
    /* Sembunyikan kartu di layar besar (Desktop) */
    @media (min-width: 768px) {
        .mobile-card-container { display: none; }
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h3 class="card-title"><?= esc($title); ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error'); ?></div>
                <?php endif; ?>

                <div class="alert alert-info shadow-sm">
                    <p class="mb-1">Tema: <strong><?= esc($tema['nama_kegiatan']); ?></strong></p>
                    <p class="mb-0">Rubrik: 1=K, 2=C, 3=B, 4=SB</p>
                </div>
                
                <form action="<?= base_url('guru/penilaian_kokurikuler/store'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <input type="hidden" name="tema_id" value="<?= esc($tema['id']); ?>">

                    <?php 
                    $dimensi_per_tema = [];
                    foreach ($detail_tema as $detail) {
                        $nomor_tema = $detail['nomor_tema'];
                        if (!isset($dimensi_per_tema[$nomor_tema])) {
                            $dimensi_per_tema[$nomor_tema] = [];
                        }
                        $dimensi_per_tema[$nomor_tema][] = $detail;
                    }
                    ?>

                    <div class="table-responsive-desktop overflow-auto">
                        <table class="table table-bordered table-sm text-center">
                            <thead class="bg-light">
                                <tr>
                                    <th>No</th>
                                    <th class="text-left">Nama Siswa</th>
                                    <?php foreach ($dimensi_per_tema as $nomor => $details) : ?>
                                        <th colspan="<?= count($details); ?>" class="bg-primary text-white">
                                            Tema <?= $nomor; ?>
                                        </th>
                                    <?php endforeach; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; foreach ($list_siswa as $siswa) : ?>
                                <tr>
                                    <td><?= $no++; ?></td>
                                    <td class="text-left"><?= esc($siswa['nama_lengkap']); ?></td>
                                    <?php foreach ($dimensi_per_tema as $nomor => $details) : ?>
                                        <?php foreach ($details as $detail) : 
                                            $key = $siswa['id'] . '-' . $nomor . '-' . $detail['dimensi'];
                                            $nilai_saat_ini = $nilai_map[$key] ?? '';
                                        ?>
                                            <td>
                                                <select class="form-control form-control-sm" name="nilai[<?= $siswa['id']; ?>][<?= $nomor; ?>][<?= $detail['dimensi']; ?>]">
                                                    <option value="">-</option>
                                                    <?php for($v=1; $v<=4; $v++): ?>
                                                        <option value="<?= $v ?>" <?= ($nilai_saat_ini == $v) ? 'selected' : ''; ?>><?= $v ?></option>
                                                    <?php endfor; ?>
                                                </select>
                                            </td>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mobile-card-container">
                        <?php $no = 1; foreach ($list_siswa as $siswa) : ?>
                            <div class="card-siswa shadow-sm">
                                <span class="nama-siswa"><?= $no++; ?>. <?= esc($siswa['nama_lengkap']); ?></span>
                                <input type="hidden" name="siswa_id[]" value="<?= esc($siswa['id']); ?>">

                                <?php foreach ($dimensi_per_tema as $nomor => $details) : ?>
                                    <div class="bg-light tema-badge border text-primary">
                                        <strong>Tema <?= $nomor; ?>:</strong> <?= esc($tema['tema_' . $nomor . '_nama'] ?? 'N/A'); ?>
                                    </div>
                                    
                                    <div class="row">
                                        <?php foreach ($details as $detail) : 
                                            $key = $siswa['id'] . '-' . $nomor . '-' . $detail['dimensi'];
                                            $nilai_saat_ini = $nilai_map[$key] ?? '';
                                        ?>
                                            <div class="col-12 mb-3">
                                                <label class="label-dimensi">
                                                    <i class="fas fa-check-circle mr-1 text-success"></i> 
                                                    <?= esc($detail['dimensi']); ?>
                                                </label>
                                                <select class="form-control" name="nilai[<?= esc($siswa['id']); ?>][<?= esc($nomor); ?>][<?= esc($detail['dimensi']); ?>]">
                                                    <option value="">Pilih Nilai -</option>
                                                    <option value="1" <?= ($nilai_saat_ini == 1) ? 'selected' : ''; ?>>1 (Kurang)</option>
                                                    <option value="2" <?= ($nilai_saat_ini == 2) ? 'selected' : ''; ?>>2 (Cukup)</option>
                                                    <option value="3" <?= ($nilai_saat_ini == 3) ? 'selected' : ''; ?>>3 (Baik)</option>
                                                    <option value="4" <?= ($nilai_saat_ini == 4) ? 'selected' : ''; ?>>4 (Sangat Baik)</option>
                                                </select>
                                                <small class="text-muted"><?= esc($detail['tujuan_pembelajaran']); ?></small>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                    <hr>
                                <?php endforeach; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="sticky-top py-3 bg-white border-top shadow-sm" style="bottom: 0; position: sticky; z-index: 100;">
                        <button type="submit" class="btn btn-success btn-block btn-lg shadow">
                            <i class="fas fa-save mr-2"></i> Simpan Semua Nilai
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>