<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h3 class="m-0 font-weight-bold text-primary">Cetak Rapor</h3>
    </div>
    <div class="card-body">
        <?php if (session()->getFlashdata('error')) : ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= session()->getFlashdata('error'); ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <form action="" method="post" id="raporForm">
            <div class="row">
                <div class="col-md-6 form-group">
                    <label for="tahun_ajaran_id">Tahun Ajaran</label>
                    <select name="tahun_ajaran_id" id="tahun_ajaran_id" class="form-control" required>
                        <option value="">-- Pilih Tahun Ajaran --</option>
                        <?php foreach ($tahun_ajaran as $ta): ?>
                            <option value="<?= esc($ta['id']) ?>">
                                <?= esc($ta['nama_tahun']) ?>
                                <?php if ($ta['aktif'] != 1): ?>
                                    (Tidak Aktif)
                                <?php endif; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6 form-group">
                    <label for="semester">Semester</label>
                    <select name="semester" id="semester" class="form-control" required>
                        <option value="">-- Pilih Semester --</option>
                        <option value="1">Ganjil</option>
                        <option value="2">Genap</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 form-group">
                    <label for="siswa_id">Siswa</label>
                    <select name="siswa_id" id="siswa_id" class="form-control" required>
                        <option value="">-- Pilih Siswa --</option>
                        <?php if (!empty($siswa)) : ?>
                            <?php foreach ($siswa as $s) : ?>
                                <option value="<?= esc($s['id']) ?>">
                                    <?= esc($s['nama_lengkap']) ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <option value="">Tidak ada siswa di kelas Anda.</option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="btn-container">
                    <button type="button" class="btn btn-primary" data-action="<?= site_url('guru/rapor/pratinjau') ?>">Pratinjau Rapor</button>
                    <button type="button" class="btn btn-primary" data-action="<?= site_url('guru/rapor/cetak') ?>">Cetak Rapor</button>
                    <button type="button" class="btn btn-primary" data-action="<?= site_url('guru/rapor/cetakLeger') ?>">Cetak Leger</button>
                    <button type="button" class="btn btn-primary" data-action="<?= site_url('guru/rapor/cetakPengambilanRapor') ?>">Cetak Pengambilan Rapor</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('raporForm');
        const buttons = document.querySelectorAll('.btn-container button');

        buttons.forEach(button => {
            button.addEventListener('click', function() {
                // Pastikan formulir valid sebelum dikirim
                if (!form.reportValidity()) {
                    return;
                }

                const actionUrl = this.getAttribute('data-action');
                
                // Set action form ke URL yang sesuai
                form.action = actionUrl;

                // Tambahkan target="_blank" jika tombol BUKAN untuk pratinjau
                if (actionUrl.includes('cetak')) {
                    form.target = '_blank';
                } else {
                    form.target = '_self'; // Buka di tab yang sama untuk pratinjau
                }
                
                // Kirim formulir
                form.submit();
            });
        });
    });
</script>
<?= $this->endSection(); ?>
