<!DOCTYPE html>
<html>
<head>
    <title>Rapor Siswa</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 11pt;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            /* Menggunakan padding yang disesuaikan */
            padding: 10mm 15mm 10mm 0mm;
            box-sizing: border-box;
        }
        .header, .footer {
            width: 100%;
        }
        .header {
            margin-bottom: 20px;
        }
        .header .school-info {
            overflow: hidden;
            text-align: center;
        }
        .header h1, .header h3 {
            margin: 0;
            padding: 0;
        }
        .divider {
            border-bottom: 2px solid black;
            margin: 10px 0;
        }
        .student-data {
            width: 100%;
            margin-top: 15px;
            margin-bottom: 25px;
        }
        .student-data table {
            width: 100%;
            border-collapse: collapse;
        }
        .student-data td {
            padding: 2px 0;
        }
        .section-title {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 20px;
        }
        table.nilai, table.ekskul, table.catatan {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table.nilai th, table.nilai td, table.ekskul th, table.ekskul td, table.catatan th, table.catatan td {
            border: 1px solid black;
            padding: 5px;
            word-wrap: break-word; 
            vertical-align: top;
        }
        table.nilai th, table.ekskul th {
            background-color: #f2f2f2;
            text-align: center;
        }

        /* Gaya untuk tabel berdampingan */
        .section-table-layout {
            width: 100%;
            border-collapse: collapse;
        }
        .section-table-layout td {
            padding: 0;
            vertical-align: top;
        }
        .section-table-layout td > * {
            margin-bottom: 20px;
        }
        table.kehadiran {
            width: 80%;
            border-collapse: collapse;
        }
        table.kehadiran th, table.kehadiran td {
            border: 1px solid black;
            padding: 5px;
            vertical-align: top;
            word-wrap: break-word;
        }
        table.catatan-wali-kelas {
            width: 80%;
            border-collapse: collapse;
        }
        table.catatan-wali-kelas td {
            border: 1px solid black;
            padding: 10px;
            vertical-align: top;
            word-wrap: break-word;
        }
        /* Style baru untuk keputusan */
        .keputusan-box {
            padding: 0px 0px 0px 0px;
            margin-top: 30px;
            margin-bottom: 20px;
            text-align: justify;
        }
        .keputusan-status {
            font-size: 12pt;
            font-weight: bold;
            margin-top: 10px;
			padding: 0px 0px 0px 0px;
        }

        /* Gaya baru untuk tabel tanda tangan */
        .ttd-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        .ttd-table td {
            border: none;
            padding: 10px;
            text-align: center;
            vertical-align: top;
        }
        .nama-gelar {
            margin-top: 50px;
            border-bottom: 1px solid black;
            display: inline-block;
            padding: 0 5px;
            margin-bottom: 0px;
        }
        .nip {
            margin-top: 0; /* Jarak antara nama dan NIP dipersempit */
        }
    </style>
</head>
<body>
    <?php 
    // =========================================================================
    // HELPER FUNCTIONS (Dimasukkan ke dalam View sesuai permintaan)
    // =========================================================================

    // Fungsi Helper untuk konversi angka Arab ke Romawi (Khusus 1-6)
    function toRoman(int $num): string
    {
        $romans = [
            1 => 'I', 2 => 'II', 3 => 'III', 4 => 'IV', 5 => 'V', 6 => 'VI'
        ];
        return $romans[$num] ?? (string)$num;
    }

    // Fungsi Helper untuk mendapatkan Tingkat Angka dari Nama Kelas (misal: "Kelas 4" -> 4)
    function getTingkatAngka(string $namaKelas): int
    {
        // Mencari angka, mengabaikan non-digit
        preg_match('/\d+/', $namaKelas, $matches);
        return (int)($matches[0] ?? 0);
    }

    // Fungsi Helper untuk menentukan Fase berdasarkan Angka Kelas
    function getFaseByTingkat(int $tingkat): string
    {
        if ($tingkat == 1 || $tingkat == 2) {
            return 'Fase A';
        } elseif ($tingkat == 3 || $tingkat == 4) {
            return 'Fase B';
        } elseif ($tingkat == 5 || $tingkat == 6) {
            return 'Fase C';
        }
        return '';
    }
	
	// FUNGSI BARU: Konversi Angka menjadi Teks (Terbilang)
    function terbilang(int $angka): string
    {
        $angka = abs($angka);
        $baca = ['', 'Satu', 'Dua', 'Tiga', 'Empat', 'Lima', 'Enam', 'Tujuh', 'Delapan', 'Sembilan', 'Sepuluh', 'Sebelas'];
        $temp = '';
        
        if ($angka < 12) {
            $temp = " " . $baca[$angka];
        } else if ($angka < 20) {
            $temp = terbilang($angka - 10) . " Belas";
        } else if ($angka < 100) {
            $temp = terbilang($angka / 10) . " Puluh" . terbilang($angka % 10);
        } else if ($angka < 200) {
            $temp = " Seratus" . terbilang($angka - 100);
        } else if ($angka < 1000) {
            $temp = terbilang($angka / 100) . " Ratus" . terbilang($angka % 100);
        } else if ($angka < 2000) {
            $temp = " Seribu" . terbilang($angka - 1000);
        } else if ($angka < 1000000) {
            $temp = terbilang($angka / 1000) . " Ribu" . terbilang($angka % 1000);
        } else {
            return "Nilai terlalu besar";
        }
        
        return trim($temp);
    }
    // =========================================================================
    ?>
    <div class="container">
        <div class="header">
            <div class="school-info">
                <h2>RAPOR PESERTA DIDIK DAN PROFIL PESERTA DIDIK</h2>
            </div>
            <br>
            <div class="divider"></div>
        </div>

        <div class="student-data">
            <table>
                <tr>
                    <td>Nama Peserta Didik</td>
                    <td>: <?= esc($siswa['nama_lengkap'] ?? '-') ?></td>
                    <td>Kelas</td>
                    <?php
					$tingkatAngka = getTingkatAngka($kelas['nama_kelas'] ?? '0');
					$tingkatTerbilang = terbilang($tingkatAngka);
					$kelasTampil = $tingkatAngka . ' (' . $tingkatTerbilang . ')';
					?>
					<td>: <?= esc($kelasTampil) ?></td>
                </tr>
                <tr>
                    <td>NISN / NIS</td>
                    <td>: <?= esc($siswa['nisn'] ?? '-') ?> / <?= esc($siswa['nis'] ?? '-') ?></td>
                    <td>Fase</td>
                    <td>: <?= esc($fase ?? '-') ?></td>
                </tr>
                <tr>
                    <td>Nama Sekolah</td>
                    <td>: <?= esc($sekolah['nama_sekolah'] ?? '-') ?></td>
                    <td>Semester</td>
                    <td>: <?= esc($tahunAjaran['semester'] ?? '-') ?></td>
                </tr>
                <tr>
                    <td>Alamat Sekolah</td>
                    <td>: <?= esc($sekolah['alamat'] ?? '-') ?></td>
                    <td>Tahun Ajaran</td>
                    <td>: <?= esc($tahunAjaran['nama_tahun'] ?? '-') ?></td>
                </tr>
            </table>
        </div>

        <p class="section-title">A. Nilai Akademik</p>
        <table class="nilai">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 25%;">Mata Pelajaran</th>
                    <th style="width: 10%;">Nilai Akhir</th>
                    <th>Capaian Kompetensi</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (!empty($nilaiMapel)) : ?>
                    <?php foreach ($nilaiMapel as $nilai) : ?>
                        <tr>
                            <td style="text-align: center;"><?= $no++ ?></td>
                            <td><?= esc($nilai['nama_mapel']) ?></td>
                            <td style="text-align: center;"><?= esc(round($nilai['nilai_akhir'])) ?></td>
                            <td style="width: 50%; padding: 5px; text-align: justify;"><?= esc($nilai['deskripsi_nilai']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="4" style="text-align: center;">Tidak ada data nilai akademik.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="section-title">B. Kegiatan Kokurikuler</div>
		<table class="data-table" style="margin-bottom: 20px;">
			<tbody>
				<tr>
					<td style="border: 1px solid black; padding: 8px; line-height: 1.5;">
						<p style="margin: 0; text-align: justify;">
							<?= esc($catatan['deskripsi_kokurikuler'] ?? 'Belum ada deskripsi Kegiatan Kokurikuler yang diinput.') ?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>
		
		<p class="section-title">C. Ekstrakurikuler</p>
        <table class="ekskul">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 25%;">Ekstrakurikuler</th>
                    <th>Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (!empty($ekstrakurikuler)) : ?>
                    <?php foreach ($ekstrakurikuler as $ekskul) : ?>
                        <tr>
                            <td style="text-align: center;"><?= $no++ ?></td>
                            <td><?= esc($ekskul['nama_ekskul']) ?></td>
                            <td><?= esc($ekskul['deskripsi_ekskul']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="3" style="text-align: center;">Tidak ada data ekstrakurikuler.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <table class="section-table-layout">
            <tr>
                <td style="width: 50%;">
                    <p class="section-title">D. Ketidakhadiran</p>
                    <table class="kehadiran">
                        <tbody>
                            <tr>
                                <td>Sakit</td>
                                <td>: <?= esc($kehadiran['sakit'] ?? 0) ?> hari</td>
                            </tr>
                            <tr>
                                <td>Izin</td>
                                <td>: <?= esc($kehadiran['izin'] ?? 0) ?> hari</td>
                            </tr>
                            <tr>
                                <td>Tanpa Keterangan</td>
                                <td>: <?= esc($kehadiran['alpha'] ?? 0) ?> hari</td>
                            </tr>
                        </tbody>
                    </table>
                </td>

                <td style="width: 50%;">
                    <p class="section-title">E. Catatan Guru Kelas</p>
                    <table class="catatan-wali-kelas">
                        <tbody>
                            <tr>
                                <td style="height: 50px; vertical-align: top;">
                                    <strong>Catatan:</strong><br>
                                    <?= esc($catatan['catatan_umum'] ?? '-') ?>
                                </td>
                            </tr>
                            <tr>
                                <td style="vertical-align: top;">
                                    <strong>Saran:</strong><br>
                                    <?= esc($catatan['saran_saran'] ?? '-') ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
        
        <?php 
        // Hanya tampil jika Semester = 2 dan data kenaikan kelas ada
        if (isset($tahunAjaran['semester']) && $tahunAjaran['semester'] == '2' && isset($kenaikanData) && !empty($kenaikanData)): 
            
            $status = ucwords(strtolower($kenaikanData['status_kenaikan'] ?? 'Belum Diatur'));
            
            // Tentukan kelas dan fase tujuan
            $kelasTujuanTeks = '';
            $faseTujuanTeks = '';

            if ($status == 'Lulus') {
                $kelasTujuanTeks = ''; // Kosongkan atau bisa diisi 'Sekolah Dasar'
                $faseTujuanTeks = '';
                $keputusanTeksFinal = "LULUS";
                
            } elseif ($status == 'Naik' && !empty($kenaikanData['nama_kelas_berikutnya'])) {
                // Ambil angka tingkat dari nama kelas berikutnya (misal: "Kelas V" -> 5)
                $tingkatTujuan = getTingkatAngka($kenaikanData['nama_kelas_berikutnya']);
                
                $kelasTujuanRomawi = toRoman($tingkatTujuan);
                $faseTujuanTeks = getFaseByTingkat($tingkatTujuan);
                
                $keputusanTeksFinal = "Naik kelas " . $kelasTujuanRomawi . " / " . $faseTujuanTeks;
                
            } elseif ($status == 'Tinggal') {
                // Tinggal kelas, gunakan kelas saat ini
                $tingkatTujuan = getTingkatAngka($kelas['nama_kelas'] ?? '');
                
                $kelasTujuanRomawi = toRoman($tingkatTujuan);
                $faseTujuanTeks = getFaseByTingkat($tingkatTujuan);
                
                $keputusanTeksFinal = "Tinggal kelas " . $kelasTujuanRomawi . " / " . $faseTujuanTeks;
                
            } else {
                $keputusanTeksFinal = "STATUS KENAIKAN BELUM DITENTUKAN";
            }

        ?>
        
		<table class="section-table-layout">
		<td style="width: 100%;">
		<p class="section-title">F. Keputusan Kenaikan Kelas</p>
				<tr>
					<td style="padding: 10px; border: 1px solid black; background-color: #f2f2f2;">
						<strong><p style="margin: 0;">Keputusan:</p></strong>
						<p style="margin: 5px 0 10px 0;">Berdasarkan pencapaian seluruh kompetensi, peserta didik dinyatakan:</p>
						<div style="font-size: 14pt; font-weight: bold; text-align: center; border: 1px solid black; padding: 10px;">
							<?= esc($keputusanTeksFinal) ?>
						</div>
					</td>
				</tr>
			</td>
		</table>
		
        <?php endif; ?>
        <table class="ttd-table">
            <tr>
                <td style="width: 45%;">
                    <p>Mengetahui,</p>
                    <p>Orang Tua/Wali</p>
                    <br><br>
                    <p class="nama-gelar">( ........................................ )</p>
                </td>
                <td style="width: 10%;"></td>
                <td style="width: 45%;">
                    <p><?= esc($sekolah['tempat_rapor'] ?? '') ?>, <?= esc(tanggal_indonesia(date('d F Y', strtotime($sekolah['tanggal_rapor'] ?? date('Y-m-d'))))); ?></p>
                    <p>Guru Kelas,</p>
                    <br><br>
                    <p class="nama-gelar"><?= esc($waliKelas['nama']) ?></p>
                    <p class="nip">NIP. <?= esc($waliKelas['nip'] ?? '-') ?></p>
                </td>
            </tr>
            <tr>
                <td colspan="3" style="text-align: center; padding-top: 50px;">
                    <p>Kepala Sekolah,</p>
                    <br><br>
                    <p class="nama-gelar"><?= esc($kepalaSekolah['nama']) ?></p>
                    <p class="nip">NIP. <?= esc($kepalaSekolah['nip'] ?? '-') ?></p>
                </td>
            </tr>
        </table>

    </div>
</body>
</html>