<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $this->renderSection('title') ? 'Guru | ' . $this->renderSection('title') : 'Guru Dashboard'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('css/guru.css') ?>">

    <style>
        :root {
            --sidebar-width-normal: 250px;
            --sidebar-width-minimized: 75px;
            --transition-speed: 0.3s;
            --primary-color: #2c3e50;
            --accent-color: #72c17e;
            --header-height: 80px;
        }

        /* Reset Box Model agar perhitungan lebar presisi */
        * { box-sizing: border-box; }

        body { 
            margin: 0; 
            padding: 0; 
            background-color: #f4f6f9; 
            overflow-x: hidden; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        aside, main, header { transition: all var(--transition-speed); }

        /* HEADER STYLING - DIKUNCI TOTAL SEPERTI BOTTOM NAV */
        header {
            background-color: var(--primary-color);
            height: var(--header-height);
            display: flex;
            align-items: center;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%; /* Mengunci lebar penuh layar */
            z-index: 1050;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            padding: 0 15px; /* Memberikan batas aman agar tidak terpotong */
        }

        .header-content {
            display: flex;
            width: 100%;
            height: 100%;
            align-items: center;
            justify-content: space-between; /* Kiri dan Kanan terpisah maksimal */
        }

        /* Sisi Kiri: Judul dan User */
        .brand-box {
            display: flex;
            flex-direction: column;
            justify-content: center;
            overflow: hidden;
        }

        .header-brand { 
            color: #fff; 
            font-weight: bold; 
            font-size: 1.5rem; 
            text-decoration: none; 
            line-height: 1.2;
            white-space: nowrap;
        }

        .header-user { 
            color: var(--accent-color); 
            font-size: 1rem; 
            margin-top: 4px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        /* Navigasi Kanan Versi PC */
        .desktop-nav {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 5px;
            gap: 20px;
        }

        .desktop-nav li a {
            color: #fff;
            text-decoration: none;
            font-size: 1rem;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        /* Tombol Menu Versi HP */
        .mobile-menu-box {
            display: none; /* Sembunyi di PC */
            align-items: center;
        }

        .mobile-menu-btn {
            background: rgba(255,255,255,0.15);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 8px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        /* SIDEBAR STYLING */
        aside { 
            width: var(--sidebar-width-normal); 
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            padding-top: var(--header-height);
            z-index: 1040;
            background: #343a40;
            overflow-y: auto;
        }

        .sidebar-header {
            padding: 15px;
            border-bottom: 1px solid #444;
        }

        /* MAIN CONTENT STYLING */
        main { 
            margin-left: var(--sidebar-width-normal); 
            padding-top: var(--header-height);
            min-height: 100vh;
        }

        .content { padding: 20px; }

        /* OVERLAY UNTUK MOBILE MENU */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 1030;
        }

        /* BOTTOM NAV (Hanya Muncul di HP) */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #ffffff;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
            z-index: 1000;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid #eee;
        }

        .mobile-bottom-nav a {
            text-align: center;
            color: #666;
            text-decoration: none;
            font-size: 0.7rem;
            flex: 1;
        }

        .mobile-bottom-nav a i {
            display: block;
            font-size: 1.2rem;
            margin-bottom: 3px;
        }

        /* RESPONSIVE LOGIC */
        @media (max-width: 768px) {
            header { padding: 0 15px; }
            .desktop-nav { display: none; }
            .mobile-menu-box { display: flex; }
            
            aside { 
                transform: translateX(-100%); /* Sembunyi ke kiri */
            }
            
            body.mobile-menu-open aside { 
                transform: translateX(0); 
            }
            
            body.mobile-menu-open .sidebar-overlay { 
                display: block; 
            }
            
            main { 
                margin-left: 0 !important; 
                padding-bottom: 85px; 
            }

            .mobile-bottom-nav { 
                display: flex; 
            }
        }

        /* Sidebar Minimized di PC */
        @media (min-width: 769px) {
            body.sidebar-minimized aside { width: var(--sidebar-width-minimized); }
            body.sidebar-minimized main { margin-left: var(--sidebar-width-minimized); }
            body.sidebar-minimized .sidebar-menu li a span,
            body.sidebar-minimized .sidebar-header h5 { display: none; }
        }
    </style>
</head>

<body id="guru-layout">

    <div class="sidebar-overlay" id="overlay"></div>

    <header>
        <div class="header-content">
            <div class="brand-box">
                <a href="<?= base_url('guru/dashboard') ?>" class="header-brand">E-Raport SDN Degung</a>
                <div class="header-user">
                    <i class="fas fa-user-circle"></i> <?= esc(session()->get('nama')); ?>
                </div>
            </div>
            
            <ul class="desktop-nav">
                <li><a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-home"></i> <span>Guru</span></a></li>
                <li><a href="<?= base_url('guru/profile') ?>"><i class="fas fa-user-circle"></i> <span>Profil</span></a></li>
                <li><a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i> <span>Siswa</span></a></li>
                <li><a href="<?= base_url('guru/kokurikuler') ?>"><i class="fas fa-project-diagram"></i> <span>Kokurikuler</span></a></li>
                <li><a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></a></li>
            </ul>

            <div class="mobile-menu-box">
                <button class="mobile-menu-btn" id="mobileMenuBtn">
                    <i class="fas fa-bars"></i> Menu
                </button>
            </div>
        </div>
    </header>

    <aside id="sidebar">
        <div class="sidebar-header">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h5 style="margin:0;"><a href="#" style="color:white; text-decoration:none;">Menu Utama</a></h5>
                <button id="sidebarToggle" class="d-none d-md-block" style="background:none; border:none; color:white; cursor:pointer;">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
        
        <ul class="sidebar-menu">
            <li><a href="<?= base_url('guru/tp_mapel') ?>"><i class="fas fa-clipboard-list"></i> <span>TP Mapel</span></a></li>
            <li><a href="<?= base_url('guru/penilaian') ?>"><i class="fas fa-edit"></i> <span>Input Nilai</span></a></li>
            <li><a href="<?= base_url('guru/rapor_cover') ?>"><i class="fas fa-book"></i> <span>Cover Raport</span></a></li>
            <li><a href="<?= base_url('guru/penilaian/deskripsi') ?>"><i class="fas fa-file-alt"></i> <span>Deskripsi</span></a></li>
            <li><a href="<?= base_url('guru/penilaian/nilaiAkhirRapor') ?>"><i class="fas fa-file-invoice"></i> <span>Nilai Akhir</span></a></li>
            <li><a href="<?= base_url('guru/kehadiran') ?>"><i class="fas fa-user-check"></i> <span>Kehadiran</span></a></li>
            <!--<li><a href="<?= base_url('guru/ljk') ?>"><i class="fas fa-file-alt"></i> <span>Lembar LJK</span></a></li>-->
			<li><a href="<?= base_url('guru/ekskul_wali_kelas') ?>"><i class="fas fa-running"></i> <span>Ekstrakurikuler</span></a></li>
            <li><a href="<?= base_url('guru/catatan_wali_kelas') ?>"><i class="fas fa-comment-dots"></i> <span>Catatan</span></a></li>
            <li><a href="<?= base_url('guru/siswa/naikKelas') ?>"><i class="fas fa-level-up-alt"></i> <span>Naik Kelas</span></a></li>
			<li><a href="<?= base_url('guru/rapor') ?>"><i class="fas fa-print"></i> <span>Cetak Rapor</span></a></li>
        </ul>
    </aside>

    <div class="mobile-bottom-nav">
        <a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-home"></i>Guru</a>
        <a href="<?= base_url('guru/profile') ?>"><i class="fas fa-user-circle"></i>Profil</a>
        <a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i>Siswa</a>
        <a href="<?= base_url('guru/kokurikuler') ?>"><i class="fas fa-project-diagram"></i>Kokurikuler</a>
        <a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i>Logout</a>
    </div>

    <main id="main-content">
        <div class="content">
            <?= $this->renderSection('content') ?>
        </div>
        <footer style="text-align: center; padding: 20px; color: #888; font-size: 0.8rem;">
            &copy; <?= date('Y'); ?> E-Raport SDN Degung. All rights reserved.
        </footer>
    </main>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script>
        $(document).ready(function() {
            // 1. Sidebar Desktop (Toggle Minimized)
            if (localStorage.getItem('sidebarState') === 'minimized') {
                $('body').addClass('sidebar-minimized');
            }
            $('#sidebarToggle').on('click', function() {
                $('body').toggleClass('sidebar-minimized');
                localStorage.setItem('sidebarState', $('body').hasClass('sidebar-minimized') ? 'minimized' : 'normal');
            });

            // 2. Sidebar Mobile (Hamburger Menu)
            $('#mobileMenuBtn, #overlay').on('click', function() {
                $('body').toggleClass('mobile-menu-open');
            });

            // 3. Menutup menu otomatis jika link diklik (khusus HP)
            $('.sidebar-menu li a').on('click', function() {
                if ($(window).width() <= 768) {
                    $('body').removeClass('mobile-menu-open');
                }
            });
        });
    </script>
</body>
</html>