<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $this->renderSection('title') ? 'Guru | ' . $this->renderSection('title') : 'Guru Dashboard'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('css/kokurikuler.css') ?>">

    <style>
        :root {
            --sidebar-width-normal: 250px;
            --sidebar-width-minimized: 75px;
            --transition-speed: 0.3s;
            --primary-color: #2c3e50;
            --accent-color: #72c17e;
            --header-height: 80px;
        }

        * { box-sizing: border-box; }

        body { margin: 0; padding: 0; background-color: #f4f6f9; overflow-x: hidden; font-family: 'Segoe UI', sans-serif; }
        aside, main, header { transition: all var(--transition-speed); }

        header {
            background-color: var(--primary-color); height: var(--header-height);
            display: flex; align-items: center; position: fixed;
            top: 0; left: 0; width: 100%; z-index: 1050;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1); padding: 0 15px;
        }

        .header-content { display: flex; width: 100%; align-items: center; justify-content: space-between; }
        .brand-box { display: flex; flex-direction: column; }
        .header-brand { color: #fff; font-weight: bold; font-size: 1.5rem; text-decoration: none; }
        .header-user { color: var(--accent-color); font-size: 1rem; margin-top: 4px; }

        .desktop-nav { display: flex; list-style: none; margin: 0; padding: 0; gap: 20px; }
        .desktop-nav li a { color: #fff; text-decoration: none; font-size: 1rem; display: flex; align-items: center; gap: 6px; }

        .mobile-menu-box { display: none; align-items: center; }
        .mobile-menu-btn {
            background: rgba(255,255,255,0.15); border: 1px solid rgba(255,255,255,0.3);
            color: white; padding: 8px 12px; border-radius: 6px; cursor: pointer;
        }

        aside { 
            width: var(--sidebar-width-normal); position: fixed; top: 0; bottom: 0; left: 0;
            padding-top: var(--header-height); z-index: 1040; background: #343a40; overflow-y: auto;
        }
        main { margin-left: var(--sidebar-width-normal); padding-top: var(--header-height); min-height: 100vh; }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1030; }

        .mobile-bottom-nav {
            display: none; position: fixed; bottom: 0; left: 0; right: 0;
            background: #ffffff; box-shadow: 0 -2px 10px rgba(0,0,0,0.1); z-index: 1000;
            justify-content: space-around; padding: 10px 0; border-top: 1px solid #eee;
        }
        .mobile-bottom-nav a { text-align: center; color: #666; text-decoration: none; font-size: 0.7rem; flex: 1; }
        .mobile-bottom-nav a i { display: block; font-size: 1.2rem; margin-bottom: 3px; }

        @media (max-width: 768px) {
            .desktop-nav { display: none; }
            .mobile-menu-box { display: flex; }
            aside { transform: translateX(-100%); }
            body.mobile-menu-open aside { transform: translateX(0); }
            body.mobile-menu-open .sidebar-overlay { display: block; }
            main { margin-left: 0 !important; padding-bottom: 85px; }
            .mobile-bottom-nav { display: flex; }
        }

        /* SIDEBAR MINIMIZE LOGIC (PC) */
        @media (min-width: 769px) {
            body.sidebar-minimized aside { width: var(--sidebar-width-minimized); }
            body.sidebar-minimized main { margin-left: var(--sidebar-width-minimized); }
            body.sidebar-minimized .sidebar-menu li a span,
            body.sidebar-minimized .sidebar-header h6 { display: none; }
            body.sidebar-minimized .sidebar-menu li a { text-align: center; justify-content: center; padding: 15px 0; }
            body.sidebar-minimized .sidebar-menu li a i { margin: 0; font-size: 1.2rem; }
        }
    </style>
</head>
<body id="kokurikuler-layout">
    <div class="sidebar-overlay" id="overlay"></div>

    <header>
        <div class="header-content">
            <div class="brand-box">
                <a href="<?= base_url('guru/dashboard') ?>" class="header-brand">Kokurikuler SDN Degung</a>
                <div class="header-user"><i class="fas fa-user-circle"></i> <?= esc(session()->get('nama')); ?></div>
            </div>
            <ul class="desktop-nav">
                <li><a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i> Siswa Saya</a></li>
                <li><a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-book"></i> Rapor</a></li>
                <li><a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
            <div class="mobile-menu-box">
                <button class="mobile-menu-btn" id="mobileMenuBtn"><i class="fas fa-bars"></i> Menu</button>
            </div>
        </div>
    </header>

    <aside id="sidebar">
        <div class="sidebar-header" style="padding:15px; border-bottom:1px solid #444;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h6 style="margin:0; color:white;">Menu Proyek</h6>
                <button id="sidebarToggle" class="d-none d-md-block" style="background:none; border:none; color:white; cursor:pointer;">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
        <ul class="sidebar-menu">
            <li><a href="<?= base_url('guru/kokurikuler') ?>"><i class="fas fa-clipboard-list"></i> <span>Manajemen Kokurikuler</span></a></li>
            <li><a href="<?= base_url('guru/penilaian_kokurikuler') ?>"><i class="fas fa-edit"></i> <span>Input Data</span></a></li>
            <li><a href="<?= base_url('guru/penilaian_kokurikuler/deskripsi') ?>"><i class="fas fa-file-signature"></i> <span>Hasil</span></a></li>
        </ul>
    </aside>

    <div class="mobile-bottom-nav">
        <a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i>Siswa</a>
        <a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-book"></i>Rapor</a>
        <a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i>Logout</a>
    </div>

    <main id="main-content">
        <div class="content"><?= $this->renderSection('content') ?></div>
    </main>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script>
        $(document).ready(function() {
            // Restore state
            if (localStorage.getItem('kokurSidebarState') === 'minimized') {
                $('body').addClass('sidebar-minimized');
            }

            // Toggle Sidebar (PC)
            $('#sidebarToggle').on('click', function() {
                $('body').toggleClass('sidebar-minimized');
                localStorage.setItem('kokurSidebarState', $('body').hasClass('sidebar-minimized') ? 'minimized' : 'normal');
            });

            // Toggle Mobile Menu
            $('#mobileMenuBtn, #overlay').on('click', function() {
                $('body').toggleClass('mobile-menu-open');
            });
        });
    </script>
</body>
</html>