<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\TahunAjaranModel;

class TahunAjaran extends BaseController
{
    protected $tahunAjaranModel;

    public function __construct()
    {
        $this->tahunAjaranModel = new TahunAjaranModel();
    }

    public function index()
    {
        $data = [
            'title'        => 'Manajemen Tahun Ajaran',
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(),
        ];

        return view('admin/tahun_ajaran/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Tahun Ajaran',
            'semester_options' => ['1', '2'],
            'validation' => \Config\Services::validation()
        ];
        return view('admin/tahun_ajaran/create', $data);
    }

    public function save()
    {
        $validationRules = [
            'nama_tahun' => 'required|is_unique[tahun_ajaran.nama_tahun]',
            'semester'   => 'required'
        ];
        
        if (!$this->validate($validationRules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'nama_tahun' => $this->request->getPost('nama_tahun'),
            'aktif'      => 0,
            'semester'   => $this->request->getPost('semester'),
        ];
        
        $this->tahunAjaranModel->save($data);
        session()->setFlashdata('success', 'Tahun ajaran berhasil ditambahkan.');
        return redirect()->to(base_url('admin/tahun_ajaran'));
    }

    public function set_active($id)
    {
        // Nonaktifkan semua tahun ajaran lain
        $this->tahunAjaranModel->set('aktif', 0)->where('id !=', $id)->update();

        // Aktifkan tahun ajaran yang dipilih
        $this->tahunAjaranModel->update($id, ['aktif' => 1]);
        session()->setFlashdata('success', 'Tahun ajaran berhasil diaktifkan.');
        return redirect()->to(base_url('admin/tahun_ajaran'));
    }

    public function edit($id)
    {
        $tahunAjaran = $this->tahunAjaranModel->find($id);

        if (empty($tahunAjaran)) {
            session()->setFlashdata('error', 'Tahun ajaran tidak ditemukan.');
            return redirect()->to(base_url('admin/tahun_ajaran'));
        }
        
        $data = [
            'title' => 'Edit Tahun Ajaran',
            'tahun_ajaran' => $tahunAjaran,
            'semester_options' => ['1', '2'],
            'validation' => \Config\Services::validation()
        ];
        
        return view('admin/tahun_ajaran/edit', $data);
    }

    public function update($id)
    {
        $validationRules = [
            'nama_tahun' => 'required[tahun_ajaran.nama_tahun,id,{id}]',
            'semester'   => 'required'
        ];

        if (!$this->validate($validationRules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'nama_tahun' => $this->request->getPost('nama_tahun'),
            'semester'   => $this->request->getPost('semester'),
        ];
        
        $this->tahunAjaranModel->update($id, $data);
        session()->setFlashdata('success', 'Tahun ajaran berhasil diperbarui.');
        return redirect()->to(base_url('admin/tahun_ajaran'));
    }
    
    public function delete($id)
    {
        $this->tahunAjaranModel->delete($id);
        session()->setFlashdata('success', 'Tahun ajaran berhasil dihapus.');
        return redirect()->to(base_url('admin/tahun_ajaran'));
    }
}
