<?php

namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\SiswaModel;
use App\Models\KelasModel; // Asumsi Anda punya model untuk Kelas
use App\Models\UserModel; // Asumsi Anda punya model untuk User/Guru

class Siswa extends BaseController
{
    protected $siswaModel;
    protected $kelasModel;
    protected $userModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
        $this->kelasModel = new KelasModel();
        $this->userModel = new UserModel();
    }

    public function index()
    {
        // --- TAMBAHKAN BARIS DEBUGGING INI ---
        //dd(session()->get('user'));
        // --- AKHIR BARIS DEBUGGING ---

        //$guruId = session()->get('user')['id']; // Baris yang error

		// 1. Dapatkan ID guru yang sedang login
        $guruId = session()->get('user_id'); // Pastikan ID user disimpan di sesi saat login

        // 2. Cari kelas yang diajar oleh guru ini
        $kelasGuru = $this->kelasModel->where('guru_kelas_id', $guruId)->findAll();

        // Jika guru tidak mengajar kelas mana pun
        if (empty($kelasGuru)) {
            $data = [
                'title' => 'Siswa Kelas Saya',
                'siswa' => [],
                'kelas' => [],
                'message' => 'Anda belum ditugaskan ke kelas mana pun.'
            ];
            return view('guru/siswa/index', $data);
        }

        // Ambil ID kelas dari kelas yang diajar guru
        $kelasIds = array_column($kelasGuru, 'id_kelas'); // Asumsi primary key kelas adalah 'id_kelas'

        // 3. Ambil semua siswa yang berada di kelas-kelas tersebut
        // Anda mungkin perlu join dengan tabel kelas untuk menampilkan nama kelas
        $siswaList = $this->siswaModel
                            ->select('siswa.*, kelas.nama_kelas')
                            ->join('kelas', 'kelas.id_kelas = siswa.kelas_id')
                            ->whereIn('siswa.kelas_id', $kelasIds)
                            ->findAll();

        $data = [
            'title' => 'Siswa Kelas Saya',
            'siswa' => $siswaList,
            'kelas' => $kelasGuru, // Kirim juga data kelas guru untuk tampilan
            'user'  => session()->get('user')
        ];

        return view('guru/siswa/index', $data);
    }
}