<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div><div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success"><?= session()->getFlashdata('success'); ?></div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error'); ?></div>
                <?php endif; ?>

                <form action="<?= base_url('admin/guru_mapel/save'); ?>" method="post">
                    <?= csrf_field(); ?>

                    <div class="form-group">
                        <label for="guru_id">Nama Guru</label>
                        <select class="form-control <?= ($validation->hasError('guru_id')) ? 'is-invalid' : ''; ?>" id="guru_id" name="guru_id">
                            <option value="">-- Pilih Guru --</option>
                            <?php foreach ($teachers as $teacher) : ?>
                                <option value="<?= esc($teacher['id']); ?>" <?= (old('guru_id') == $teacher['id']) ? 'selected' : ''; ?>>
                                    <?= esc($teacher['nama']); ?> (<?= esc($teacher['username']); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <?php if ($validation->hasError('guru_id')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('guru_id'); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="mapel_id">Nama Mata Pelajaran</label>
                        <select class="form-control <?= ($validation->hasError('mapel_id')) ? 'is-invalid' : ''; ?>" id="mapel_id" name="mapel_id">
                            <option value="">-- Pilih Mata Pelajaran --</option>
                            <?php foreach ($subjects as $subject) : ?>
                                <option value="<?= esc($subject['id']); ?>" <?= (old('mapel_id') == $subject['id']) ? 'selected' : ''; ?>>
                                    <?= esc($subject['nama_mapel']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <?php if ($validation->hasError('mapel_id')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('mapel_id'); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="id_kelas">Kelas</label>
                        <select class="form-control <?= ($validation->hasError('id_kelas')) ? 'is-invalid' : ''; ?>" id="id_kelas" name="id_kelas">
                            <option value="">-- Pilih Kelas --</option>
                            <?php foreach ($kelas as $k) : ?>
                                <option value="<?= $k['id_kelas']; ?>" <?= (old('id_kelas') == $k['id_kelas']) ? 'selected' : ''; ?>>
                                    <?= $k['nama_kelas']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <?php if ($validation->hasError('id_kelas')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('id_kelas'); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('admin/guru_mapel'); ?>" class="btn btn-secondary ml-2">Batal</a>
                </form>
            </div></div></div></div><?= $this->endSection(); ?>