<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
				<a href="<?= base_url('admin/users/new') ?>" class="btn btn-success mb-3">Tambah Pengguna Baru</a>
				</div>
				</div>
				<div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
				<table class="table table-bordered table-hover" id="data_table"> 
					<thead>
						<tr>
							<th>No.</th>
							<th>Username</th>
							<th>Nama</th>
							<th>NIP</th>
							<th>Role</th>
							<th>Aksi</th>
						</tr>
					</thead>
					<tbody>
						<?php $no = 1; foreach ($daftarUser as $user): ?>
							<tr>
								<td><?= $no++ ?></td>
								<td><?= esc($user['username']) ?></td>
								<td><?= esc($user['nama']) ?></td>
								<td><?= esc($user['nip']) ?></td>
								<td><?= esc($user['role']) ?></td>
								<td>
									<a href="<?= base_url('admin/users/edit/' . $user['id']) ?>" class="btn btn-primary btn-sm">Edit</a>
									<a href="<?= base_url('admin/users/delete/' . $user['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus pengguna ini?')">Hapus</a>
								</td>
							</tr>
						<?php endforeach; ?>
						<?php if (empty($daftarUser)): ?>
							<tr>
								<td colspan="6">Tidak ada data pengguna.</td>
							</tr>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?= $this->endSection() ?>