<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $this->renderSection('title') ? 'Guru | ' . $this->renderSection('title') : 'Guru Dashboard'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('css/guru.css') ?>">
</head>
<body>

    <header>
        <nav>
            <ul>
                <li><a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-home"></i> Guru</a></li>
                <li><a href="<?= base_url('guru/profile') ?>"><i class="fas fa-user-circle"></i> Profil</a></li>
                <li><a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i> Siswa Kelas Saya</a></li>
                <li><a href="<?= base_url('guru/kokurikuler') ?>"><i class="fas fa-project-diagram"></i> Kokorikuler</a></li>
                <li><a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </nav>
    </header>

    <aside>
        <div class="sidebar-header">
            <h5><a href="#" class="sidebar-title">E-Raport SDN Degung</a></h5>
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="info">
        <span class="d-block" style="color: #72c17e;">
            <strong>Halo, Sdr/i. <?= esc(session()->get('nama')); ?></strong>
        </span>
        </div>
        </div>
        </div>
        <ul class="sidebar-menu">
            <li><a href="<?= base_url('guru/tp_mapel') ?>"><i class="fas fa-clipboard-list"></i> Manajemen TP Mapel</a></li>
            <li><a href="<?= base_url('guru/penilaian') ?>"><i class="fas fa-edit"></i> Input Nilai</a></li>
            <li><a href="<?= base_url('guru/rapor_cover') ?>"><i class="fas fa-book"></i> Cover Raport</a></li>
            <li><a href="<?= base_url('guru/penilaian/deskripsi') ?>"><i class="fas fa-file-alt"></i> Deskripsi Mapel</a></li>
			<li><a href="<?= base_url('guru/penilaian/nilaiAkhirRapor') ?>"><i class="nav-icon fas fa-file-invoice"></i> Nilai Akhir Rapor</a></li>
            <!--<li><a href="<?= base_url('guru/fisik_anak') ?>"><i class="fas fa-project-diagram"></i> Fisik Anak</a></li>-->
            <li><a href="<?= base_url('guru/kehadiran') ?>"><i class="fas fa-user-check"></i> Kehadiran</a></li>
            <li><a href="<?= base_url('guru/ekskul_wali_kelas') ?>"><i class="fas fa-running"></i> Ekstrakurikuler</a></li>
            <li><a href="<?= base_url('guru/catatan_wali_kelas') ?>"><i class="fas fa-comment-dots"></i> Catatan Wali Kelas</a></li>
            <li><a href="<?= base_url('guru/rapor') ?>"><i class="fas fa-print"></i> Cetak Rapor</a></li>
        </ul>
    </aside>

    <main>
        <div class="content">
            <?= $this->renderSection('content') ?>
        </div>
        <footer>
            <p>&copy; <?= date('Y'); ?> E-Raport SDN Degung. All rights reserved.</p>
        </footer>
    </main>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>