<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();

        // Jika belum login, redirect ke halaman login
        if (!$session->get('logged_in')) {
            return redirect()->to(base_url('/'))->with('error', 'Anda harus login untuk mengakses halaman ini.');
        }

        // Jika ada argumen role (misal 'auth:admin', 'auth:guru')
        if ($arguments && !empty($arguments)) {
            $requiredRole = $arguments[0]; // Ambil role pertama dari argumen filter
            $userRole = $session->get('role');

            // Jika peran pengguna tidak sesuai dengan peran yang dibutuhkan
            if ($userRole !== $requiredRole) {
                // Redirect ke dashboard sesuai peran atau halaman error
                if ($userRole === 'admin') {
                    return redirect()->to(base_url('admin/dashboard'))->with('error', 'Anda tidak memiliki akses ke halaman ini.');
                } elseif ($userRole === 'guru') {
                    return redirect()->to(base_url('guru/dashboard'))->with('error', 'Anda tidak memiliki akses ke halaman ini.');
                } elseif ($userRole === 'kepala_sekolah') {
                    return redirect()->to(base_url('kepsek/dashboard'))->with('error', 'Anda tidak memiliki akses ke halaman ini.');
                } else {
                    // Default fallback
                    return redirect()->to(base_url('/'))->with('error', 'Akses ditolak.');
                }
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do something here or leave empty
    }
}