<?php

namespace App\Models;

use CodeIgniter\Model;

class KenaikanKelasModel extends Model
{
    protected $table            = 'kenaikan_kelas';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['siswa_id', 'tahun_ajaran_id', 'status_kenaikan', 'kelas_berikutnya_id', 'catatan'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'siswa_id'          => 'required|is_natural_no_zero',
        'tahun_ajaran_id'   => 'required|is_natural_no_zero',
        'status_kenaikan'   => 'required|in_list[naik,tinggal_kelas,belum_ditentukan]',
        'kelas_berikutnya_id' => 'permit_empty|is_natural_no_zero', // Hanya wajib jika status_kenaikan = 'naik'
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
}