<?php

namespace App\Models;

use CodeIgniter\Model;

class SekolahModel extends Model
{
    protected $table            = 'sekolah';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = false; // Menonaktifkan perlindungan field untuk input fleksibel
    protected $allowedFields    = [
        'nama_sekolah', 'nss','npsn', 'alamat', 'kode_pos', 'telp',
        'kelurahan_desa', 'kapanewon', 'kabupaten_kota', 'provinsi',
        'website', 'email', 'tempat_rapor', 'tanggal_rapor', 'kepala_sekolah_id'
    ];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Tidak ada aturan validasi
}
