<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>
<h1><?= esc($title) ?></h1>
<p>Isi formulir di bawah ini untuk menambahkan data siswa baru.</p>

<form action="<?= base_url('admin/siswa/store') ?>" method="post">
    <?= csrf_field() ?>

    <h2>Data Pribadi Siswa</h2>
    <label for="nama_lengkap">Nama Lengkap:</label>
    <input type="text" id="nama_lengkap" name="nama_lengkap"
           value="<?= old('nama_lengkap') ?>"
           class="<?= ($validation->hasError('nama_lengkap')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('nama_lengkap')): ?>
        <p class="text-danger"><?= $validation->getError('nama_lengkap') ?></p>
    <?php endif; ?>
    <br><br>

	<label for="nama_panggilan">Nama Panggilan:</label>
    <input type="text" id="nama_panggilan" name="nama_panggilan"
           value="<?= old('nama_panggilan') ?>"
           class="<?= ($validation->hasError('nama_panggilan')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('nama_panggilan')): ?>
        <p class="text-danger"><?= $validation->getError('nama_panggilan') ?></p>
    <?php endif; ?>
    <br><br>

	<label for="jenis_kelamin">Jenis Kelamin:</label>
    <input type="text" id="jenis_kelamin" name="jenis_kelamin"
           value="<?= old('jenis_kelamin') ?>"
           class="<?= ($validation->hasError('jenis_kelamin')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('jenis_kelamin')): ?>
        <p class="text-danger"><?= $validation->getError('jenis_kelamin') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="agama">Agama:</label>
    <input type="text" id="agama" name="agama"
           value="<?= old('agama') ?>"
           class="<?= ($validation->hasError('agama')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('agama')): ?>
        <p class="text-danger"><?= $validation->getError('agama') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nisn">NISN (10 digit):</label>
    <input type="text" id="nisn" name="nisn"
           value="<?= old('nisn') ?>"
           class="<?= ($validation->hasError('nisn')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nisn')): ?>
        <p class="text-danger"><?= $validation->getError('nisn') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nis">NIS (maks 10 digit):</label>
    <input type="text" id="nis" name="nis"
           value="<?= old('nis') ?>"
           class="<?= ($validation->hasError('nis')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nis')): ?>
        <p class="text-danger"><?= $validation->getError('nis') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="pendidikan_sebelumnya">Pendidikan Sebelumnya:</label>
    <input type="text" id="pendidikan_sebelumnya" name="pendidikan_sebelumnya"
           value="<?= old('pendidikan_sebelumnya') ?>"
           class="<?= ($validation->hasError('pendidikan_sebelumnya')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('pendidikan_sebelumnya')): ?>
        <p class="text-danger"><?= $validation->getError('pendidikan_sebelumnya') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="kelas_id">Kelas:</label>
    <select id="kelas_id" name="kelas_id"
            class="<?= ($validation->hasError('kelas_id')) ? 'is-invalid' : ''; ?>" required>
        <option value="">-- Pilih Kelas --</option>
        <?php foreach ($kelasOptions as $kelas): ?>
            <option value="<?= esc($kelas['id_kelas']) ?>" <?= (old('kelas_id') == $kelas['id_kelas']) ? 'selected' : '' ?>>
                <?= esc($kelas['nama_kelas']) ?> // Sesuaikan dengan nama kolom kelas Anda
            </option>
        <?php endforeach; ?>
    </select>
    <?php if ($validation->hasError('kelas_id')): ?>
        <p class="text-danger"><?= $validation->getError('kelas_id') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="tempat_lahir">Tempat Lahir:</label>
    <input type="text" id="tempat_lahir" name="tempat_lahir"
           value="<?= old('tempat_lahir') ?>"
           class="<?= ($validation->hasError('tempat_lahir')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('tempat_lahir')): ?>
        <p class="text-danger"><?= $validation->getError('tempat_lahir') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="tanggal_lahir">Tanggal Lahir:</label>
    <input type="date" id="tanggal_lahir" name="tanggal_lahir"
           value="<?= old('tanggal_lahir') ?>"
           class="<?= ($validation->hasError('tanggal_lahir')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('tanggal_lahir')): ?>
        <p class="text-danger"><?= $validation->getError('tanggal_lahir') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="alamat">Alamat:</label>
    <textarea id="alamat" name="alamat"
              class="<?= ($validation->hasError('alamat')) ? 'is-invalid' : ''; ?>"><?= old('alamat') ?></textarea>
    <?php if ($validation->hasError('alamat')): ?>
        <p class="text-danger"><?= $validation->getError('alamat') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="kelurahan_desa">Kelurahan/Desa:</label>
    <input type="text" id="kelurahan_desa" name="kelurahan_desa"
           value="<?= old('kelurahan_desa') ?>"
           class="<?= ($validation->hasError('kelurahan_desa')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('kelurahan_desa')): ?>
        <p class="text-danger"><?= $validation->getError('kelurahan_desa') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="kapanewon">Kapanewon:</label>
    <input type="text" id="kapanewon" name="kapanewon"
           value="<?= old('kapanewon') ?>"
           class="<?= ($validation->hasError('kapanewon')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('kapanewon')): ?>
        <p class="text-danger"><?= $validation->getError('kapanewon') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="kabupaten_kota">Kabupaten/Kota:</label>
    <input type="text" id="kabupaten_kota" name="kabupaten_kota"
           value="<?= old('kabupaten_kota') ?>"
           class="<?= ($validation->hasError('kabupaten_kota')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('kabupaten_kota')): ?>
        <p class="text-danger"><?= $validation->getError('kabupaten_kota') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="provinsi">Provinsi:</label>
    <input type="text" id="provinsi" name="provinsi"
           value="<?= old('provinsi') ?>"
           class="<?= ($validation->hasError('provinsi')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('provinsi')): ?>
        <p class="text-danger"><?= $validation->getError('provinsi') ?></p>
    <?php endif; ?>
    <br><br>

    <h2>Data Orang Tua / Wali</h2>
    <label for="nama_ayah">Nama Ayah:</label>
    <input type="text" id="nama_ayah" name="nama_ayah"
           value="<?= old('nama_ayah') ?>"
           class="<?= ($validation->hasError('nama_ayah')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nama_ayah')): ?>
        <p class="text-danger"><?= $validation->getError('nama_ayah') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="pekerjaan_ayah">Pekerjaan Ayah:</label>
    <input type="text" id="pekerjaan_ayah" name="pekerjaan_ayah"
           value="<?= old('pekerjaan_ayah') ?>"
           class="<?= ($validation->hasError('pekerjaan_ayah')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('pekerjaan_ayah')): ?>
        <p class="text-danger"><?= $validation->getError('pekerjaan_ayah') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nama_ibu">Nama Ibu:</label>
    <input type="text" id="nama_ibu" name="nama_ibu"
           value="<?= old('nama_ibu') ?>"
           class="<?= ($validation->hasError('nama_ibu')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nama_ibu')): ?>
        <p class="text-danger"><?= $validation->getError('nama_ibu') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="pekerjaan_ibu">Pekerjaan Ibu:</label>
    <input type="text" id="pekerjaan_ibu" name="pekerjaan_ibu"
           value="<?= old('pekerjaan_ibu') ?>"
           class="<?= ($validation->hasError('pekerjaan_ibu')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('pekerjaan_ibu')): ?>
        <p class="text-danger"><?= $validation->getError('pekerjaan_ibu') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="nama_wali">Nama Wali (opsional):</label>
    <input type="text" id="nama_wali" name="nama_wali"
           value="<?= old('nama_wali') ?>"
           class="<?= ($validation->hasError('nama_wali')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('nama_wali')): ?>
        <p class="text-danger"><?= $validation->getError('nama_wali') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="pekerjaan_wali">Pekerjaan Wali (opsional):</label>
    <input type="text" id="pekerjaan_wali" name="pekerjaan_wali"
           value="<?= old('pekerjaan_wali') ?>"
           class="<?= ($validation->hasError('pekerjaan_wali')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('pekerjaan_wali')): ?>
        <p class="text-danger"><?= $validation->getError('pekerjaan_wali') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="alamat_wali">Alamat Wali (opsional):</label>
    <textarea id="alamat_wali" name="alamat_wali"
              class="<?= ($validation->hasError('alamat_wali')) ? 'is-invalid' : ''; ?>"><?= old('alamat_wali') ?></textarea>
    <?php if ($validation->hasError('alamat_wali')): ?>
        <p class="text-danger"><?= $validation->getError('alamat_wali') ?></p>
    <?php endif; ?>
    <br><br>

    <button type="submit">Simpan Siswa</button>
    <a href="<?= base_url('admin/siswa') ?>" class="btn btn-warning">Kembali ke Daftar Siswa</a>
</form>
<?= $this->endSection() ?>