<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <!--<?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (isset($validation)) : ?>
                    <div class="alert alert-danger">
                        <?= $validation->listErrors(); ?>
                    </div>
                <?php endif; ?>-->
                
                <form action="<?= base_url('guru/ekskul_wali_kelas/save_add'); ?>" method="post">
                    <?= csrf_field(); ?>
                    
                    <div class="form-group">
                        <label for="siswa">Pilih Siswa</label>
                        <select class="form-control" id="siswa" name="siswa_id" required>
                            <option value="">-- Pilih Siswa --</option>
                            <?php foreach ($siswa_list as $siswa) : ?>
                                <option value="<?= $siswa['id']; ?>"><?= esc($siswa['nama_lengkap']); ?> - (Kelas <?= esc($siswa['nama_kelas']); ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="ekskul">Pilih Ekstrakurikuler</label>
                        <select class="form-control" id="ekskul" name="ekskul_id" required>
                            <option value="">-- Pilih Ekskul --</option>
                            <?php foreach ($ekskul_list as $ekskul) : ?>
                                <option value="<?= $ekskul['id']; ?>"><?= esc($ekskul['nama_ekskul']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="deskripsi_ekskul">Deskripsi Ekstrakurikuler</label>
                        <textarea class="form-control" id="deskripsi_ekskul" name="deskripsi_ekskul" rows="3" required></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('guru/ekskul_wali_kelas'); ?>" class="btn btn-secondary">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>