<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\GuruMapelModel;
use App\Models\UserModel; // Untuk mendapatkan daftar guru
use App\Models\MataPelajaranModel; // Untuk mendapatkan daftar mata pelajaran
use App\Models\KelasModel; // Tambahkan model ini

class GuruMapel extends BaseController
{
    protected $guruMapelModel;
    protected $userModel;
    protected $mataPelajaranModel;
    protected $kelasModel; // Deklarasikan model Kelas

    public function __construct()
    {
        $this->guruMapelModel = new GuruMapelModel();
        $this->userModel = new UserModel();
        $this->mataPelajaranModel = new MataPelajaranModel();
        $this->kelasModel = new KelasModel(); // Inisialisasi model Kelas
    }

    public function index()
    {
        // Ambil semua penugasan guru-mapel untuk ditampilkan
        $dataGuruMapel = $this->guruMapelModel
                            ->select('guru_mapel.*, users.nama as nama_guru, mata_pelajaran.nama_mapel, kelas.nama_kelas') // Tambahkan kolom nama_kelas
                            ->join('users', 'users.id = guru_mapel.guru_id', 'left')
                            ->join('mata_pelajaran', 'mata_pelajaran.id = guru_mapel.mapel_id', 'left')
                            ->join('kelas', 'kelas.id_kelas = guru_mapel.id_kelas', 'left') // Tambahkan join ke tabel kelas
                            ->findAll();

        $data = [
            'title' => 'Manajemen Penugasan Guru Mata Pelajaran',
            'guru_mapel_assignments' => $dataGuruMapel,
            'user'  => session()->get('user')
        ];
        return view('admin/guru_mapel/index', $data);
    }

    public function create()
    {
        // Dapatkan daftar guru (role 'guru'), mata pelajaran, dan kelas untuk dropdown
        $teachers = $this->userModel->where('role', 'guru')->findAll();
        $subjects = $this->mataPelajaranModel->findAll();
        $kelas = $this->kelasModel->findAll(); // BARU: Dapatkan semua data kelas

        $data = [
            'title' => 'Tambah Penugasan Guru Mata Pelajaran Baru',
            'teachers' => $teachers,
            'subjects' => $subjects,
            'kelas' => $kelas, // BARU: Kirim data kelas ke view
            'validation' => service('validation'),
            'user'  => session()->get('user')
        ];
        return view('admin/guru_mapel/create', $data);
    }

    public function store()
    {
        // Tambahkan baris kode ini untuk debugging
          //  var_dump($this->request->getVar());
          //  die();
        
        // Validasi input
        $rules = [
            'guru_id' => 'required|numeric',
            'mapel_id' => 'required|numeric',
            'id_kelas' => 'required|numeric', // BARU: Tambahkan validasi untuk id_kelas
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $guru_id = $this->request->getVar('guru_id');
        $mapel_id = $this->request->getVar('mapel_id');
        $id_kelas = $this->request->getVar('id_kelas'); // BARU: Ambil id_kelas dari POST

        // Cek apakah penugasan sudah ada untuk menghindari duplikasi
        $existingAssignment = $this->guruMapelModel
                                    ->where('guru_id', $guru_id)
                                    ->where('mapel_id', $mapel_id)
                                    ->where('id_kelas', $id_kelas) // BARU: Cek juga berdasarkan id_kelas
                                    ->first();

        if ($existingAssignment) {
            session()->setFlashdata('error', 'Penugasan guru ke mata pelajaran ini di kelas tersebut sudah ada.');
            return redirect()->back()->withInput();
        }

        // Simpan penugasan baru
        $this->guruMapelModel->save([
            'guru_id' => $guru_id,
            'mapel_id' => $mapel_id,
            'id_kelas' => $id_kelas, // BARU: Simpan id_kelas
        ]);

        session()->setFlashdata('success', 'Penugasan guru ke mata pelajaran berhasil ditambahkan.');
        return redirect()->to(base_url('admin/guru_mapel'));
    }

    public function delete($id)
    {
        $assignment = $this->guruMapelModel->find($id);

        if (empty($assignment)) {
            session()->setFlashdata('error', 'Penugasan tidak ditemukan.');
            return redirect()->to(base_url('admin/guru_mapel'));
        }

        $this->guruMapelModel->delete($id);
        session()->setFlashdata('success', 'Penugasan berhasil dihapus.');
        return redirect()->to(base_url('admin/guru_mapel'));
    }
}