<?php namespace App\Models;

use CodeIgniter\Model;

class PenilaianKokurikulerModel extends Model
{
    protected $table      = 'penilaian_kokurikuler';
    protected $primaryKey = 'id';
    
    protected $useAutoIncrement = true;
    protected $returnType     = 'array';

    // Asumsi kolom-kolom untuk menyimpan nilai
    protected $allowedFields = [
        'tema_id',          // ID dari kokurikuler_tema yang dinilai
        'siswa_id',         // ID Siswa
        'tahun_ajaran_id',
        'kelas_id',
        'nomor_tema',       // 1, 2, atau 3
        'dimensi',
        'nilai',            // Nilai 1, 2, 3, atau 4
        'deskripsi',        // Deskripsi otomatis berdasarkan rubrik
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $dateFormat    = 'datetime';
}