<?php

namespace App\Models;

use CodeIgniter\Model;

class TpMapelModel extends Model
{
    protected $table      = 'tp_mapel'; // Nama tabel di database Anda
    protected $primaryKey = 'id'; // <<< DISESUAIKAN: Berubah dari 'id_tp_mapel' menjadi 'id'

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    // Kolom-kolom yang diperbolehkan untuk diisi
    protected $allowedFields = [
        'mapel_id',         // <<< TETAP: ID Mata Pelajaran (FK ke tabel mata_pelajaran)
        'kelas_id',
		'kode_tp',          // <<< BARU: Menambahkan kolom kode_tp
        'deskripsi_tp',     // <<< TETAP: Deskripsi Tujuan Pembelajaran
        'semester',
		'tahun_ajaran_id',
		// <<< DIHAPUS: 'kelas_id' dan 'tahun_ajaran_id' karena tidak ada di daftar kolom yang Anda berikan
    ];

    // Dates
    protected $useTimestamps = true; // Tetap true karena ada created_at dan updated_at
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
}