<?= $this->extend('layout/kokurikuler_layout'); ?> 

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('errors')) : ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php foreach (session()->getFlashdata('errors') as $error) : ?>
                                <li><?= esc($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <?php if (empty($kelas_wali)) : ?>
                    <div class="alert alert-danger">Anda tidak terdaftar sebagai wali kelas. Fitur ini hanya dapat diakses oleh wali kelas.</div>
                <?php else : ?>
                    <form action="<?= base_url('guru/kokurikuler/update/' . $tema['id']); ?>" method="post" id="formKokurikuler">
                        <?= csrf_field(); ?>
                        <input type="hidden" name="_method" value="PUT"> 
                        
                        <input type="hidden" name="kelas_id" value="<?= esc($tema['kelas_id'] ?? ''); ?>">
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tahun_ajaran_id">Tahun Ajaran</label>
                                    <select class="form-control" id="tahun_ajaran_id" name="tahun_ajaran_id" required>
                                        <option value="">-- Pilih Tahun Ajaran --</option>
                                        <?php foreach ($tahun_ajaran_options as $ta) : ?>
                                            <option value="<?= esc($ta['id']); ?>" 
                                                <?= (old('tahun_ajaran_id', $tema['tahun_ajaran_id']) == $ta['id']) ? 'selected' : ''; ?>>
                                                <?= esc($ta['nama_tahun']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="semester">Semester</label>
                                    <select class="form-control" id="semester" name="semester" required>
                                        <option value="">-- Pilih Semester --</option>
                                        <?php foreach ($semester_options as $key => $val) : ?>
                                            <option value="<?= esc($key); ?>" 
                                                <?= (old('semester', $tema['semester']) == $key) ? 'selected' : ''; ?>>
                                                <?= esc($val); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Kelas Wali</label>
                                    <input type="text" class="form-control" value="<?= esc($kelas_wali['nama_kelas'] ?? 'N/A'); ?>" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="nama_kegiatan">Nama Kegiatan Kokurikuler</label>
                            <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" 
                                   value="<?= old('nama_kegiatan', $tema['nama_kegiatan']); ?>" required>
                        </div>

                        <hr>
                        <h5 class="mb-3">Detail Tema (Penamaan, Tujuan Pembelajaran, dan Dimensi)</h5>

                        <?php for ($i = 1; $i <= 3; $i++) : ?>
                            <div class="card card-outline card-primary mb-4" id="tema_card_<?= $i; ?>">
                                <div class="card-header">
                                    <h4 class="card-title">Tema <?= $i; ?></h4>
                                </div>
                                <div class="card-body">
                                    
                                    <div class="form-group">
                                        <label for="tema_<?= $i; ?>_nama">Penamaan Tema <?= $i; ?></label>
                                        <textarea class="form-control" id="tema_<?= $i; ?>_nama" name="tema_<?= $i; ?>_nama" rows="2" required><?= old("tema_{$i}_nama", $tema["tema_{$i}_nama"]); ?></textarea>
                                    </div>
                                    
                                    <hr>
                                    
                                    <label class="mt-3">Dimensi dan Tujuan Pembelajaran (Min 2, Maks 4)</label>
                                    
                                    <div id="detail_container_<?= $i; ?>">
                                        <?php 
                                            $detail_rows = $grouped_detail[$i] ?? [];
                                            $j = 0; 
                                            foreach ($detail_rows as $detail) : 
                                        ?>
                                            <div class="row detail-row mb-3" data-detail-index="<?= esc($j); ?>">
                                                <div class="col-md-5">
                                                    <div class="form-group">
                                                        <select class="form-control" name="dimensi_<?= esc($i); ?>[]" required>
                                                            <option value="">-- Pilih Dimensi --</option>
                                                            <?php foreach ($dimensi_list as $dimensi) : ?>
                                                                <option value="<?= esc($dimensi); ?>" 
                                                                    <?= (old("dimensi_{$i}")[$j] ?? esc($detail['dimensi'])) == $dimensi ? 'selected' : ''; ?>>
                                                                    <?= esc($dimensi); ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-5">
                                                    <div class="form-group">
                                                        <textarea class="form-control" name="tujuan_<?= esc($i); ?>[]" rows="3" required><?= old("tujuan_{$i}")[$j] ?? esc($detail['tujuan_pembelajaran']); ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-2 d-flex align-items-center">
                                                    <button type="button" class="btn btn-danger btn-sm remove-detail">
                                                        <i class="fas fa-trash"></i> Hapus
                                                    </button>
                                                </div>
                                                <div class="col-12"><hr class="my-1"></div>
                                            </div>
                                        <?php $j++; endforeach; ?>
                                        </div>
                                    
                                    <button type="button" class="btn btn-sm btn-success mt-3 add-detail" data-tema="<?= $i; ?>">
                                        <i class="fas fa-plus"></i> Tambah Dimensi & Tujuan
                                    </button>
                                    
                                </div>
                            </div>
                        <?php endfor; ?>

                        <button type="submit" class="btn btn-primary">Perbarui Tema Kokurikuler</button>
                        <a href="<?= base_url('guru/kokurikuler'); ?>" class="btn btn-secondary">Batal</a>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    const dimensiList = <?= json_encode($dimensi_list); ?>;
    
    // Fungsi untuk membuat HTML baris detail
    function createDetailRow(temaIndex, detailIndex, selectedDimensi = '', tujuanText = '') {
        // ... (fungsi sama seperti di create.php) ...
        const row = document.createElement('div');
        row.className = 'row detail-row mb-3';
        row.dataset.detailIndex = detailIndex;
        
        let selectOptions = `<option value="">-- Pilih Dimensi --</option>`;
        dimensiList.forEach(dimensi => {
            const selected = (selectedDimensi === dimensi) ? 'selected' : '';
            selectOptions += `<option value="${dimensi}" ${selected}>${dimensi}</option>`;
        });

        row.innerHTML = `
            <div class="col-md-5">
                <div class="form-group">
                    <select class="form-control" name="dimensi_${temaIndex}[]" required>
                        ${selectOptions}
                    </select>
                </div>
            </div>
            <div class="col-md-5">
                <div class="form-group">
                    <textarea class="form-control" name="tujuan_${temaIndex}[]" rows="3" required>${tujuanText}</textarea>
                </div>
            </div>
            <div class="col-md-2 d-flex align-items-center">
                <button type="button" class="btn btn-danger btn-sm remove-detail">
                    <i class="fas fa-trash"></i> Hapus
                </button>
            </div>
            <div class="col-12"><hr class="my-1"></div>
        `;
        return row;
    }

    // Fungsi untuk mengecek batas minimum
    function checkMinMax(temaIndex) {
        const container = document.getElementById(`detail_container_${temaIndex}`);
        const rows = container.querySelectorAll('.detail-row');
        const count = rows.length;
        
        // Cek tombol Hapus (Min 2)
        container.querySelectorAll('.remove-detail').forEach(btn => {
            // Tampilkan tombol hapus hanya jika jumlah baris > 2
            btn.style.display = (count > 2) ? 'block' : 'none'; 
        });
        
        // Cek tombol Tambah (Max 4)
        const addBtnTema = document.querySelector(`.add-detail[data-tema="${temaIndex}"]`);
        addBtnTema.disabled = (count >= 4);
    }
    
    document.addEventListener('DOMContentLoaded', function() {
        for (let i = 1; i <= 3; i++) {
            const container = document.getElementById(`detail_container_${i}`);
            
            // JIKA TIDAK ADA DATA TERSIMPAN (SETELAH PHP LOOP DI ATAS), TAMBAHKAN 2 BARIS DEFAULT
            if (container.children.length === 0) {
                 for (let j = 0; j < 2; j++) {
                    const newRow = createDetailRow(i, j);
                    container.appendChild(newRow);
                }
            }
            
            checkMinMax(i);
        }

        // Event listener untuk tombol 'Tambah Dimensi & Tujuan'
        document.querySelectorAll('.add-detail').forEach(button => {
            button.addEventListener('click', function() {
                const temaIndex = this.dataset.tema;
                const container = document.getElementById(`detail_container_${temaIndex}`);
                const rows = container.querySelectorAll('.detail-row');
                
                if (rows.length < 4) {
                    const newIndex = rows.length; 
                    const newRow = createDetailRow(temaIndex, newIndex);
                    container.appendChild(newRow);
                }
                
                checkMinMax(temaIndex);
            });
        });

        // Event listener untuk tombol 'Hapus'
        document.getElementById('formKokurikuler').addEventListener('click', function(e) {
            if (e.target.closest('.remove-detail')) {
                const removeBtn = e.target.closest('.remove-detail');
                const rowToRemove = removeBtn.closest('.detail-row');
                const temaCard = removeBtn.closest('.card');
                const temaIndex = temaCard.id.split('_')[2];
                
                // Hanya hapus jika lebih dari minimum (2)
                if (temaCard.querySelectorAll('.detail-row').length > 2) {
                    rowToRemove.remove();
                    checkMinMax(temaIndex);
                } else {
                    alert('Minimal harus ada 2 pasang Dimensi dan Tujuan Pembelajaran per tema.');
                }
            }
        });
        
    });
</script>

<?= $this->endSection(); ?>