<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success"><?= session()->getFlashdata('success'); ?></div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error'); ?></div>
                <?php endif; ?>

                <form action="<?= base_url('guru/nilai_rapor/store'); ?>" method="post">
                    <?= csrf_field(); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="guru_mapel_id">Pilih Penugasan Guru Mapel</label>
                                <select class="form-control" id="guru_mapel_id" name="guru_mapel_id">
                                    <option value="">-- Pilih Guru Mapel --</option>
                                    <?php foreach ($guru_mapel_assignments as $assignment) : ?>
                                        <option value="<?= $assignment['id']; ?>" <?= (old('guru_mapel_id') == $assignment['id']) ? 'selected' : ''; ?>>
                                            <?= $assignment['nama_mapel'] . ' - ' . $assignment['nama_kelas']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="semester">Semester</label>
                                <select class="form-control" id="semester" name="semester">
                                    <option value="">-- Pilih Semester --</option>
                                    <option value="1" <?= (old('semester') == '1') ? 'selected' : ''; ?>>1</option>
                                    <option value="2" <?= (old('semester') == '2') ? 'selected' : ''; ?>>2</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="tahun_ajaran_id">Tahun Ajaran</label>
                                <select class="form-control" id="tahun_ajaran_id" name="tahun_ajaran_id">
                                    <option value="">-- Pilih Tahun Ajaran --</option>
                                    <?php foreach ($tahun_ajaran as $ta) : ?>
                                        <option value="<?= $ta['id']; ?>" <?= (old('tahun_ajaran_id') == $ta['id']) ? 'selected' : ''; ?>>
                                            <?= $ta['tahun_ajaran']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div id="siswa-list" class="mt-4">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Siswa</th>
                                    <th>Nilai Akhir</th>
                                    <th>Deskripsi</th>
                                </tr>
                            </thead>
                            <tbody>
                                </tbody>
                        </table>
                    </div>

                    <button type="submit" class="btn btn-primary mt-3">Simpan Nilai Rapor</button>
                    <a href="<?= base_url('guru/nilai_rapor'); ?>" class="btn btn-secondary mt-3 ml-2">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>

<?= $this->section('scripts'); ?>
<script>
    document.getElementById('guru_mapel_id').addEventListener('change', function() {
        var guruMapelId = this.value;
        var tableBody = document.querySelector('#siswa-list tbody');
        tableBody.innerHTML = ''; // Kosongkan tabel
        
        if (guruMapelId) {
            fetch('<?= base_url('guru/nilai_rapor/getSiswa'); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': '<?= csrf_hash(); ?>'
                },
                body: 'guru_mapel_id=' + guruMapelId
            })
            .then(response => response.json())
            .then(data => {
                let no = 1;
                data.forEach(siswa => {
                    let row = `
                        <tr>
                            <td>${no++}</td>
                            <td>${siswa.nama_lengkap}</td>
                            <td>
                                <input type="number" class="form-control" name="siswa_nilai[${siswa.id}]" min="0" max="100" required>
                            </td>
                            <td>
                                <textarea class="form-control" name="siswa_deskripsi[${siswa.id}]"></textarea>
                            </td>
                        </tr>
                    `;
                    tableBody.innerHTML += row;
                });
            });
        }
    });
</script>
<?= $this->endSection(); ?>