<?php

namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\NilaiRaporModel;
use App\Models\SiswaModel;
use App\Models\GuruMapelModel;
use App\Models\MataPelajaranModel;
use App\Models\KelasModel;
use App\Models\TahunAjaranModel;

class NilaiRapor extends BaseController
{
    protected $nilaiRaporModel;
    protected $siswaModel;
    protected $guruMapelModel;
    protected $mapelModel;
    protected $kelasModel;
    protected $tahunAjaranModel;

    public function __construct()
    {
        $this->nilaiRaporModel = new NilaiRaporModel();
        $this->siswaModel = new SiswaModel();
        $this->guruMapelModel = new GuruMapelModel();
        $this->mapelModel = new MataPelajaranModel();
        $this->kelasModel = new KelasModel();
        $this->tahunAjaranModel = new TahunAjaranModel();
    }

    public function index()
    {
        // Logika untuk menampilkan daftar nilai rapor yang sudah ada
        $dataNilaiRapor = $this->nilaiRaporModel
                           ->select('nilai_rapor.*, siswa.nama_lengkap as nama_siswa, mata_pelajaran.nama_mapel, kelas.nama_kelas, users.nama as nama_guru, tahun_ajaran.tahun_ajaran')
                           ->join('siswa', 'siswa.id = nilai_rapor.siswa_id')
                           ->join('mata_pelajaran', 'mata_pelajaran.id = nilai_rapor.mapel_id')
                           ->join('kelas', 'kelas.id_kelas = nilai_rapor.kelas_id')
                           ->join('users', 'users.id = nilai_rapor.guru_id')
                           ->join('tahun_ajaran', 'tahun_ajaran.id = nilai_rapor.tahun_ajaran_id')
                           ->findAll();

        $data = [
            'title' => 'Input Nilai Akhir Rapor',
            'nilai_rapor' => $dataNilaiRapor,
        ];

        return view('guru/nilai_rapor', $data);
    }
    
    public function create()
   {
        $guru_id = session()->get('id');
        $guruMapelAssignments = $this->guruMapelModel
                                    ->select('guru_mapel.*, mata_pelajaran.nama_mapel, kelas.nama_kelas')
                                    ->join('mata_pelajaran', 'mata_pelajaran.id = guru_mapel.mapel_id')
                                    ->join('kelas', 'kelas.id_kelas = guru_mapel.id_kelas')
                                    ->where('guru_mapel.guru_id', $guru_id)
                                    ->findAll();
        
        $data = [
            'title' => 'Input Nilai Akhir Rapor',
            'validation' => \Config\Services::validation(),
            'guru_mapel_assignments' => $guruMapelAssignments,
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(), // Ambil data dari model
        ];
        
        return view('guru/nilai_rapor/create', $data);
    }

    public function getSiswa()
    {
        // Method AJAX untuk mendapatkan siswa berdasarkan guru_mapel_id
        $guruMapelId = $this->request->getPost('guru_mapel_id');
    
    $assignment = $this->guruMapelModel->find($guruMapelId);
    
    if ($assignment) {
        $siswa = $this->siswaModel->select('id, nama_lengkap')->where('kelas_id', $assignment['id_kelas'])->findAll();
        return $this->response->setJSON($siswa);
    }
    
    return $this->response->setJSON([]);
    }

    public function store()
    {
        $rules = [
            'guru_mapel_id' => 'required|numeric',
            'semester' => 'required|numeric',
            'tahun_ajaran_id' => 'required|numeric',
            // Aturan validasi untuk nilai_akhir akan lebih kompleks, 
            // kita akan validasi per siswa
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $guruMapelId = $this->request->getPost('guru_mapel_id');
        $assignment = $this->guruMapelModel->find($guruMapelId);

        $siswa_nilai = $this->request->getPost('siswa_nilai');
        $siswa_deskripsi = $this->request->getPost('siswa_deskripsi');
        
        // Simpan nilai untuk setiap siswa
        foreach ($siswa_nilai as $siswa_id => $nilai_akhir) {
            if (!empty($nilai_akhir)) {
                $deskripsi = isset($siswa_deskripsi[$siswa_id]) ? $siswa_deskripsi[$siswa_id] : null;

                // Cek apakah nilai sudah ada, jika ada, update, jika tidak, insert
                $existing = $this->nilaiRaporModel->where([
                    'siswa_id' => $siswa_id,
                    'mapel_id' => $assignment['mapel_id'],
                    'kelas_id' => $assignment['id_kelas'],
                    'semester' => $this->request->getPost('semester'),
                    'tahun_ajaran_id' => $this->request->getPost('tahun_ajaran_id')
                ])->first();

                $data = [
                    'siswa_id' => $siswa_id,
                    'guru_id' => session()->get('id'),
                    'mapel_id' => $assignment['mapel_id'],
                    'kelas_id' => $assignment['id_kelas'],
                    'nilai_akhir' => $nilai_akhir,
                    'deskripsi' => $deskripsi,
                    'semester' => $this->request->getPost('semester'),
                    'tahun_ajaran_id' => $this->request->getPost('tahun_ajaran_id'),
                ];
                
                if ($existing) {
                    $this->nilaiRaporModel->update($existing['id'], $data);
                } else {
                    $this->nilaiRaporModel->insert($data);
                }
            }
        }

        session()->setFlashdata('success', 'Nilai akhir rapor berhasil disimpan.');
        return redirect()->to(base_url('guru/nilai_rapor'));
    }
}