<?= $this->extend('layout/admin_layout') ?> // Pastikan ini sesuai dengan layout admin Anda

<<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
					<p>Daftar lengkap semua siswa yang terdaftar.</p>

					<a href="<?= base_url('admin/siswa/create') ?>" class="btn btn-success">Tambah Siswa Baru</a>
					<a href="<?= base_url('admin/siswa/import') ?>" class="btn btn-primary">Import Siswa (Excel/CSV)</a>
					<a href="<?= base_url('download/format_upload.xlsx') ?>" class="btn btn-danger btn-sm">Contoh Format (Excel/CSV)</a>
					</div>
					</div>
				<div class="card-body">
					<?php if (session()->getFlashdata('success')) : ?>
						<div class="alert alert-success alert-dismissible fade show" role="alert">
							<?= session()->getFlashdata('success'); ?>
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
					<?php endif; ?>
					<table class="table table-bordered table-hover" id="data_table">
						<thead>
							<tr>
								<th>No.</th>
								<th>Nama Lengkap</th>
								<th>NISN</th>
								<th>NIS</th>
								<th>Kelas</th>
								<th>Tempat, Tanggal Lahir</th>
								<th>Alamat</th>
								<th>Aksi</th>
							</tr>
						</thead>
						<tbody>
							<?php if (empty($daftarSiswa)): ?>
								<tr>
									<td colspan="8">Tidak ada data siswa.</td>
								</tr>
							<?php else: ?>
								<?php $no = 1; ?>
								<?php foreach ($daftarSiswa as $siswa): ?>
									<tr>
										<td><?= $no++ ?></td>
										<td><?= esc($siswa['nama_lengkap']) ?></td>
										<td><?= esc($siswa['nisn'] ?? '-') ?></td>
										<td><?= esc($siswa['nis'] ?? '-') ?></td>
										<td><?= esc($siswa['kelas_id'] ?? '-') ?></td> <td><?= esc($siswa['tempat_lahir'] ?? '-') ?>, <?= esc($siswa['tanggal_lahir'] ?? '-') ?></td>
										<td><?= esc($siswa['alamat'] ?? '-') ?></td>
										<td>
											<a href="<?= base_url('admin/siswa/edit/' . $siswa['id']) ?>" class="btn btn-primary btn-sm">Edit</a>
											<form action="<?= base_url('admin/siswa/delete/' . $siswa['id']) ?>" method="post" style="display:inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus siswa ini?');">
												<?= csrf_field() ?>
												<input type="hidden" name="_method" value="DELETE">
												<button type="submit" class="btn btn-danger btn-sm">Hapus</button>
											</form>
										</td>
									</tr>
								<?php endforeach; ?>
							<?php endif; ?>
						</tbody>
					</table>
				</div>
		</div>
	</div>
</div>
<?= $this->endSection() ?>