<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $this->renderSection('title') ? 'Admin | ' . $this->renderSection('title') : 'Admin Dashboard'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('css/admin.css') ?>">
</head>
<body>

    <header>
        <nav>
            <ul>
                <li><a href="<?= base_url('admin/dashboard') ?>"><i class="fas fa-user-shield"></i> Admin</a></li>
                <li><a href="<?= base_url('admin/users') ?>"><i class="fas fa-users"></i> Pengguna</a></li>
                <li><a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </nav>
    </header>

    <aside>
        <div class="sidebar-header">
            <h5><a href="<?= base_url('admin/dashboard') ?>" class="sidebar-title">E-Raport SDN Degung</a></h5>
        </div>
        <ul class="sidebar-menu">
            <li><a href="<?= base_url('admin/sekolah') ?>"><i class="fas fa-school"></i> Sekolah</a></li>
            <li><a href="<?= base_url('admin/tahun_ajaran') ?>"><i class="fas fa-calendar-alt"></i> Tahun Ajaran</a></li>
            <li><a href="<?= base_url('admin/guru_mapel') ?>"><i class="fas fa-chalkboard-teacher"></i> Penugasan Guru</a></li>
            <li><a href="<?= base_url('admin/mata_pelajaran') ?>"><i class="fas fa-book"></i> Mata Pelajaran</a></li>
			<li><a href="<?= base_url('admin/rentang_nilai') ?>"><i class="fas fa-edit"></i> Rentang Nilai</a></li>
            <li><a href="<?= base_url('admin/kelas') ?>"><i class="fas fa-chalkboard"></i> Kelas</a></li>
            <li><a href="<?= base_url('admin/siswa') ?>"><i class="fas fa-user-graduate"></i> Data Siswa</a></li>
			<li><a href="<?= base_url('admin/ekstrakurikuler') ?>"><i class="fas fa-running"></i> Data Ekstrakurikuler</a></li>
        </ul>
    </aside>

    <main>
        <div class="content">
            <?= $this->renderSection('content'); ?>
        </div>
        <footer>
            <p>&copy; <?= date('Y'); ?> E-Raport SDN Degung. All rights reserved.</p>
        </footer>
    </main>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>